<?php
/**
 * Created by PhpStorm.
 * User: jderosa
 * Date: 06/08/19
 * Time: 15.11
 */

namespace FiloBlu\Rma\Ui\Component\Listing\Columns;

use Magento\Backend\Model\UrlInterface;
use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Magento\Framework\View\Element\UiComponentFactory;
use Magento\Ui\Component\Listing\Columns\Column;

/**
 *
 */
class Actions extends Column
{
    /**
     * @var UrlInterface
     */
    protected $urlBuilder;


    /**
     * Actions constructor.
     * @param ContextInterface $context
     * @param UiComponentFactory $uiComponentFactory
     * @param UrlInterface $urlBuilder
     * @param array $components
     * @param array $data
     */
    public function __construct(ContextInterface   $context,
                                UiComponentFactory $uiComponentFactory,
                                UrlInterface       $urlBuilder,
                                array              $components = [],
                                array              $data = [])
    {
        $this->urlBuilder = $urlBuilder;
        parent::__construct($context, $uiComponentFactory, $components, $data);
    }

    /**
     * @param array $dataSource
     * @return array
     */
    public function prepareDataSource(array $dataSource)
    {
        if (isset($dataSource['data']['items'])) {
            foreach ($dataSource['data']['items'] as &$item) {
                if (isset($item['rma_entity_id'])) {
                    $item[$this->getData('name')] =
                        [
                            'view' =>
                                [
                                    'href'   => $this->urlBuilder->getUrl(
                                        'adminhtml/rma/edit',
                                        [
                                            'id' => $item['rma_entity_id']
                                        ]
                                    ),
                                    'target' => '_blank',
                                    'label'  => __('View')
                                ]

                        ];
                }
            }
        }
        return $dataSource;
    }

}
