<?php

namespace FiloBlu\Rma\Plugin\Sales\Block\Order;

use FiloBlu\Rma\Model\OrderLocator;

/**
 *
 */
class Totals
{
    /**
     * @var OrderLocator
     */
    private $orderLocator;

    /**
     * @param OrderLocator $orderLocator
     */
    public function __construct(
        OrderLocator $orderLocator
    )
    {
        $this->orderLocator = $orderLocator;
    }

    /**
     * @param $subject
     * @param $result
     * @return \Magento\Sales\Api\Data\OrderInterface|mixed
     */
    public function afterGetOrder($subject, $result)
    {
        $changeSizeOrder = $this->orderLocator->hasOrder() ? $this->orderLocator->getCurrentOrder() : null;

        if ($changeSizeOrder && $changeSizeOrder->getPayment()->getMethod() !== 'changesizepay') {
            $changeSizeOrder = null;
        }

        return $changeSizeOrder ?? $result;
    }
}
