<?php
/**
 * Created by PhpStorm.
 * User: jderosa
 * Date: 26/06/19
 * Time: 12.53
 */

namespace FiloBlu\Rma\Model\ResourceModel\EasyReturn;


use FiloBlu\Rma\Model\EasyReturn;
use Magento\Framework\DB\Select;
use Magento\Framework\Model\ResourceModel\Db\Collection\AbstractCollection;
use Zend_Db_Select;

/**
 *
 */
class Collection extends AbstractCollection
{
    /**
     * Resource initialization.
     */
    protected $_idFieldName = 'id';
    /**
     * @var string
     */
    protected $_eventPrefix = 'filoblu_rma_easyreturn_grid_collection';
    /**
     * @var string
     */
    protected $_eventObject = 'filoblu_rma_easyreturn_collection';

    /**
     * @return Select
     */
    public function getSelectCountSql()
    {
        $countSelect = parent::getSelectCountSql();
        $countSelect->reset(Zend_Db_Select::GROUP);
        return $countSelect;
    }

    /**
     * @param $field
     * @param null $condition
     * @return $this
     */
    public function addFieldToSearchFilter($field, $condition = null)
    {
        $field = $this->_getMappedField($field);
        $this->_select->orWhere($this->_getConditionSql($field, $condition));
        return $this;
    }

    /**
     *
     * @noinspection MagicMethodsValidityInspection
     */
    protected function _construct()
    {
        $this->_init(EasyReturn::class, \FiloBlu\Rma\Model\ResourceModel\EasyReturn::class);
    }

    /**
     * @param string $valueField
     * @param string $labelField
     * @param array $additional
     * @return array
     */
    protected function _toOptionArray($valueField = 'id', $labelField = 'id', $additional = [])
    {
        return parent::_toOptionArray($valueField, $labelField, $additional);
    }

}
