<?php

/**
 * Created by PhpStorm.
 * User: jderosa
 * Date: 22/10/19
 * Time: 12.46
 */

namespace FiloBlu\Rma\Console;

use Exception;
use FiloBlu\Rma\Model\SyncChangeSizeOrder as SyncChangeSizeOrderModel;
use Magento\Framework\App\State;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

use function count;

/**
 *
 */
class SyncChangeSizeOrder extends Command
{
    /** @var int */
    const CHUNK_LIMIT = 500;

    /**
     * @var SyncChangeSizeOrderModel
     */
    protected $changeSizeOrder;

    /**
     * @var State
     */
    private $state;

    /**
     * SyncChangeSizeOrder constructor.
     * @param State $state
     * @param SyncChangeSizeOrderModel $changeSizeOrder
     * @param string|null $name
     */
    public function __construct(
        State $state,
        SyncChangeSizeOrderModel $changeSizeOrder,
        string $name = null
    ) {
        parent::__construct($name);
        $this->state = $state;
        $this->changeSizeOrder = $changeSizeOrder;
    }

    /**
     *
     */
    protected function configure()
    {
        $this->setName('filoblu:sync-changesize-order-and-rma');
        $this->setDescription('Run this code to sync ChangeSizeOrder with rma_item within filoblu_rma_items table');
        parent::configure();
    }

    /**
     * @param InputInterface $input
     * @param OutputInterface $output
     * @return void
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {

        try {
            $this->state->setAreaCode('adminhtml');
            //delete existing data - init
            $output->write('<info>Deleting existings values...</info>');
            $this->changeSizeOrder->deleteExistingsValues();
            $output->writeln('OK!');
            $output->write('<info>Get All ChangeSize Orders Data...</info>');
            $changeSizeData = $this->changeSizeOrder->getAllChangeSizeOrderData();
            $output->writeln('found ' . count($changeSizeData) . ' valid ChangeSizeOrders');
            $output->write('Start Sync...');
            $this->processOrdersAndSetChangeSizeLinkage($output, $changeSizeData);
            $output->writeln('<info>Sync ChangeSize Orders -> ✌  Apposc`t!</info>');
        } catch (Exception $exception) {
            $output->writeln($exception->getMessage());
        }
    }

    /**
     * @param $output
     * @param array $changeSizeData
     */
    public function processOrdersAndSetChangeSizeLinkage($output, array $changeSizeData)
    {
        $idChunks = array_chunk($changeSizeData, self::CHUNK_LIMIT, true);

        try {
            foreach ($idChunks as $ids) {
                $res = $this->changeSizeOrder->insertChangeSizeOrderBulk($ids);
                if (isset($res[0]) && $res[0]) {
                    $response = '<info>' . count($ids) . ' Change Size Sync -> ✌  Apposc`t!</info>';
                    $output->writeln($response);
                } else {
                    $response = $res[1] ?? 'Error while processing ChangeSizeOrders';
                    $output->writeln($response);
                    break;
                }
            }
        } catch (Exception $exception) {
            $output->writeln($exception->getMessage());
        }
    }
}
