<?php
/**
 * Created by PhpStorm.
 * User: jderosa
 * Date: 22/04/20
 * Time: 11.25
 */

namespace FiloBlu\Rma\Block\Adminhtml\Order\View\Tab;

use Exception;
use FiloBlu\Rma\Block\Adminhtml\Rma\Grid\Renderer\RmaType;
use Magento\Backend\Block\Template\Context;
use Magento\Framework\Registry;
use Magento\Rma\Helper\Data;
use Magento\Rma\Model\ResourceModel\Rma\Grid\CollectionFactory;
use Magento\Rma\Model\RmaFactory;
use Throwable;

/**
 *
 */
class Rma extends \Magento\Rma\Block\Adminhtml\Order\View\Tab\Rma
{
    /**
     * @var Data
     */
    private $rmaData;

    /**
     * Rma constructor.
     * @param Context $context
     * @param \Magento\Backend\Helper\Data $backendHelper
     * @param CollectionFactory $collectionFactory
     * @param RmaFactory $rmaFactory
     * @param Registry $coreRegistry
     * @param Data $rmaHelper
     * @param Data $rmaData
     * @param array $data
     */
    public function __construct(
        Context                      $context,
        \Magento\Backend\Helper\Data $backendHelper,
        CollectionFactory            $collectionFactory,
        RmaFactory                   $rmaFactory,
        Registry                     $coreRegistry,
        Data                         $rmaHelper,
        Data                         $rmaData,
        array                        $data = [])
    {
        parent::__construct($context,
            $backendHelper,
            $collectionFactory,
            $rmaFactory,
            $coreRegistry,
            $rmaHelper,
            $data);
        $this->rmaData = $rmaData;
    }

    /**
     * @return bool
     */
    public function canShowTab()
    {
        try {
            return $this->rmaData->canCreateRma($this->getOrder(), true);
        } catch (Exception $e) {
            $this->_logger->critical($e->getMessage(), ['exception' => $e]);
            return false;
        } catch (Throwable $t) {
            $this->_logger->critical($t->getMessage(), ['exception' => $t]);
            return false;
        }
    }

    /**
     * Prepare grid columns
     *
     * @return \Magento\Rma\Block\Adminhtml\Rma\Grid|void
     */
    protected function _prepareColumns()
    {
        $this->addColumnAfter(
            'rma_type',
            [
                'header' => __('Rma Type'),
                'index' => 'rma_type',
                'renderer' => RmaType::class
            ],
            'status'
        );

        return parent::_prepareColumns();
    }

}
