<?php

/**
 * Created by PhpStorm.
 * User: jderosa
 * Date: 28/10/19
 * Time: 16.55
 */

namespace FiloBlu\Rma\Api;

/**
 *
 */
interface ChangeSizeInterface
{
    /**
     * @param int $itemId
     * @param int $qty
     * @param int $resolution
     * @param int $reason
     * @param int $websiteId
     * @return mixed
     */
    public function getSizes(int $itemId, int $qty, int $resolution, int $reason, int $websiteId);

    /**
     * @return string|null
     */
    public function getLabel();

    /**
     * @param string $productIds
     * @param int $websiteId
     * @return mixed
     */
    public function getChangeSizeEnabledProducts(string $productIds, int $websiteId);


    /**
     * @param int $itemId
     * @param int $qty
     * @return \FiloBlu\Rma\Api\Data\RmaAttributeMetadataInterface[]
     */
    public function getAllAttributesWithAlternativesMetadata(int $itemId, int $qty);
}
