<?php

namespace FiloBlu\Rma\Block\Adminhtml\System\Config;

use Magento\Backend\Block\Template\Context;
use Magento\Config\Block\System\Config\Form\Field\FieldArray\AbstractFieldArray;
use Magento\Eav\Model\ResourceModel\Entity\Attribute\Option\Collection;
use Magento\Eav\Model\ResourceModel\Entity\Attribute\Option\CollectionFactory;
use Magento\Framework\View\Element\Html\Select;
use Magento\Rma\Api\RmaAttributesManagementInterface;

class RmaAttributes extends AbstractFieldArray
{
    /**
     * @var CollectionFactory
     */
    protected $attributeOptionCollectionFactory;
    /**
     * @var RmaAttributesManagementInterface
     */
    private $rmaAttributesManagement;

    /**
     * @param \Magento\Backend\Block\Template\Context $context
     * @param \Magento\Eav\Model\ResourceModel\Entity\Attribute\Option\CollectionFactory $attributeOptionCollectionFactory
     * @param \Magento\Rma\Api\RmaAttributesManagementInterface $rmaAttributesManagement
     * @param array $data
     */
    public function __construct(
        Context $context,
        CollectionFactory $attributeOptionCollectionFactory,
        RmaAttributesManagementInterface $rmaAttributesManagement,
        array $data = []
    )
    {
        parent::__construct($context, $data);
        $this->attributeOptionCollectionFactory = $attributeOptionCollectionFactory;
        $this->rmaAttributesManagement = $rmaAttributesManagement;
    }

    /**
     * Prepare to render
     */
    protected function _prepareToRender()
    {
        $resolutions = $this->getOptionsData();

        array_unshift($resolutions, ['value' => '*', 'label' => __('-- Select --')]);

        $resolutionsBlock = $this->getLayout()
            ->createBlock(Select::class)
            ->setId($this->_getCellInputElementId('<%- _id %>', 'rma_resolution'))
            ->setName($this->_getCellInputElementName('rma_resolution'))
            ->setClass('select')
            ->setOptions($resolutions);

        $this->addColumn(
            'rma_resolution',
            [
                'label' => __('Rma Resolution'),
                'class' => 'required-entry',
                'renderer' => $resolutionsBlock
            ]
        );
        $this->addColumn(
            'netsuite_id',
            [
                'label' => __('NETSUITE id'),
                'class' => 'required-entry'
            ]
        );

        $this->_addAfter = false;
        $this->_addButtonLabel = __('Add Another Resolution');
    }

    /**
     * @return array
     */
    public function getOptionsData()
    {
        $attributes = $this->rmaAttributesManagement->getAllAttributesMetadata();

        $options = [];

        foreach ($attributes as $attributeCode) {

            if ($attributeCode->getAttributeCode() === 'resolution') {
                foreach ($attributeCode->getOptions() as $option) {

                    if (empty(trim($option->getLabel()))) {
                        continue;
                    }

                    $options[] = [
                        'value' => $option->getValue(),
                        'label' => sprintf('%s - id: %s', ucfirst($option->getLabel()), $option->getValue()),
                    ];
                }
            }
        }

        return $options;
    }

    /**
     * Get options data
     *
     * @return array
     */
    protected function getOptionsData2()
    {
        $attributeCode = 'resolution'; // Replace with your attribute code

        /** @var Collection $optionCollection */
        $optionCollection = $this->attributeOptionCollectionFactory->create()
            ->setAttributeFilter($attributeCode)
            ->setPositionOrder('asc', true);

        $optionsData = [];
        foreach ($optionCollection as $option) {
            $optionsData[$option->getValue()] = ['option_' . $option->getId() => 'selected="selected"'];
        }

        return $optionsData;
    }
}
