<?php

namespace FiloBlu\Rma\Block\Adminhtml\Rma\Widget\Grid;

use FiloBlu\Rma\Helper\ChangeSizeAttributeHelper;
use Magento\Backend\Block\Template\Context;
use Magento\Framework\App\Request\Http;
use Magento\Sales\Model\OrderRepository;

class Column extends \Magento\Backend\Block\Widget\Grid\Column
{
    /**
     * @var Http
     */
    private $request;
    /**
     * @var ChangeSizeAttributeHelper
     */
    private $changeSizeAttributeHelper;
    /**
     * @var OrderRepository
     */
    private $orderRepository;

    public function __construct(
        Context $context,
        Http $request,
        ChangeSizeAttributeHelper $changeSizeAttributeHelper,
        OrderRepository $orderRepository,
        array $data = []
    )
    {
        $this->request = $request;
        $this->changeSizeAttributeHelper = $changeSizeAttributeHelper;
        $this->orderRepository = $orderRepository;
        parent::__construct($context, $data);
    }


    public function isDisplayed()
    {

        if ($this->getId() == 'changesize') {
            $orderId = $this->request->getParam('order_id');
            $order = $this->orderRepository->get($orderId);
            if (!$this->changeSizeAttributeHelper->isChangeSizeEnabled($order->getStoreId())) {
                return false;
            }
        }

        return parent::isDisplayed(); // TODO: Change the autogenerated stub
    }
}