<?php
/**
 * Copyright © 2019 Filoblu S.r.l. All rights reserved.
 */

namespace FiloBlu\Rma\Block\Adminhtml\System;

use FiloBlu\Rma\Api\Model\Config\Reader;
use Magento\Framework\Config\CacheInterface;
use Magento\Framework\Config\Data;

/**
 *
 */
class Config extends Data
{
    /**
     * @param Reader $reader
     * @param CacheInterface $cache
     * @param string $cacheId
     */
    public function __construct(
        Reader         $reader,
        CacheInterface $cache,
                       $cacheId = 'rma_reasons'
    )
    {
        parent::__construct($reader, $cache, $cacheId);
    }

    /**
     * Get configuration of reason by name
     *
     * @param string $name
     * @return array
     */
    public function getField($name)
    {
        return $this->get($name, []);
    }

    /**
     * Get configuration of all registered rma reasons
     *
     * @return array
     */
    public function getAll()
    {
        return $this->get();
    }
}
