<?php

namespace FiloBlu\Rma\Ui\Component\Listing\Columns\ResolutionHistory;

use Magento\Backend\Model\UrlInterface;
use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Magento\Framework\View\Element\UiComponentFactory;
use Magento\Ui\Component\Listing\Columns\Column;

class RmaIncrementId extends Column
{
    /**
     * @var UrlInterface
     */
    private $urlBuilder;
    /**
     * @var \Magento\Framework\App\Request\Http
     */
    private $request;

    /**
     * @param ContextInterface $context
     * @param UiComponentFactory $uiComponentFactory
     * @param UrlInterface $urlBuilder
     * @param array $components
     * @param array $data
     */
    public function __construct(
        ContextInterface $context,
        UiComponentFactory $uiComponentFactory,
        UrlInterface $urlBuilder,
        \Magento\Framework\App\Request\Http $request,
        array $components = [],
        array $data = []
    )
    {
        parent::__construct($context, $uiComponentFactory, $components, $data);
        $this->urlBuilder = $urlBuilder;
        $this->request = $request;
    }

    /**
     * @param array $dataSource
     * @return array
     */
    public function prepareDataSource(array $dataSource)
    {
        $key = $this->urlBuilder->getSecretKey('adminhtml', 'rma', 'edit');

        if (isset($dataSource['data']['items'])) {
            foreach ($dataSource['data']['items'] as &$item) {
                if (isset($item['parent_increment_id'])) {
                    $item[$this->getData('name')] =
                        [
                            $item['parent_increment_id'] =>
                                [
                                    'href'   => $this->urlBuilder->getRouteUrl(
                                        'admin/rma/edit',
                                        [
                                            'id' => $item['parent_id'],
                                            'key' => $key,
                                            'test' => 1
                                        ]
                                    ),
                                    'target' => '_blank',
                                    'label'  => '#'.$item['parent_increment_id']
                                ]

                        ];
                }
            }
        }
        return $dataSource;
    }
}
