<?php
/**
 * Created by PhpStorm.
 * User: jderosa
 * Date: 18/02/20
 * Time: 9.42
 */
namespace FiloBlu\Rma\Ui\Component\Listing\Columns\Method;
use Magento\Payment\Helper\Data;
use Magento\Framework\App\ResourceConnection;


class Options implements \Magento\Framework\Data\OptionSourceInterface
{
    /**
     * @var array
     */
    protected $options;

    /**
     * @var \Magento\Payment\Helper\Data
     */
    protected $paymentHelper;

    /**
     * @var ResourceConnection
     */
    protected $resourceConnection;

    /**
     * Options constructor.
     * @param Data $paymentHelper
     * @param ResourceConnection $resourceConnection
     */
    public function __construct(Data $paymentHelper,
                                ResourceConnection $resourceConnection)
    {
        $this->paymentHelper = $paymentHelper;
        $this->resourceConnection = $resourceConnection;
    }

    /**
     * Get options
     *
     * @return array
     */
    public function toOptionArray()
    {
        $payments = $this->paymentHelper->getPaymentMethodList(true, true);
        $connection  = $this->resourceConnection->getConnection();
        $tableName   = $connection->getTableName('core_config_data');
        $query = "SELECT path,value FROM $tableName WHERE path LIKE 'payment/%/title' AND scope='default'";
        $result = $connection->fetchAll($query);
        $realPaymentData = [];
        foreach ($result as $val ){
            $code = explode("/",$val['path'])[1];
            $title = $val['value'];
            $realPaymentData[$code]['value']=$code;
            $realPaymentData[$code]['label']=$title;
        }
        $newData = array_merge($payments,$realPaymentData);
        return $newData;
    }
}