<?php

namespace FiloBlu\Rma\Ui\Component\Listing\Columns\ChangeSizeItems;

use FiloBlu\Rma\Helper\ChangeSizeItemsHelper;
use Magento\Backend\Model\UrlInterface;
use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Magento\Framework\View\Element\UiComponentFactory;
use Magento\Ui\Component\Listing\Columns\Column;

class ChangeSizeOrderIncrementId extends Column
{
    protected $urlBuilder;
    /**
     * @var ChangeSizeItemsHelper
     */
    private $changeSizeItemsHelper;

    /**
     * @param ContextInterface $context
     * @param UiComponentFactory $uiComponentFactory
     * @param UrlInterface $urlBuilder
     * @param ChangeSizeItemsHelper $changeSizeItemsHelper
     * @param array $components
     * @param array $data
     */
    public function __construct(
        ContextInterface $context,
        UiComponentFactory $uiComponentFactory,
        UrlInterface $urlBuilder,
        ChangeSizeItemsHelper $changeSizeItemsHelper,
        array $components = [],
        array $data = []
    ) {
        $this->urlBuilder = $urlBuilder;
        parent::__construct($context, $uiComponentFactory, $components, $data);
        $this->changeSizeItemsHelper = $changeSizeItemsHelper;
    }

    public function prepareDataSource(array $dataSource)
    {
        if (isset($dataSource['data']['items'])) {
            foreach ($dataSource['data']['items'] as & $item) {

                if (empty($item['change_size_order_id'])) {
                    $item[$this->getData('name')] = '';

                    continue;
                }

                if (!$this->changeSizeItemsHelper->doesOrderExists($item['change_size_order_id'])) {

                    $item[$this->getData('name')] = '';

                    continue;
                }

                $item[$this->getData('name')] = "<a href='{$this->urlBuilder->getUrl('sales/order/view', ['order_id' => $item['change_size_order_id']])}' target='_blank'>#{$item[$this->getData('name')]}</a>";
            }
        }

        return $dataSource;
    }
}
