<?php
/**
 * Created by PhpStorm.
 * User: jderosa
 * Date: 25/06/19
 * Time: 10.59
 */

namespace FiloBlu\Rma\Model;

use Magento\Framework\DataObject\IdentityInterface;
use Magento\Framework\Model\AbstractModel;

/**
 *
 */
class RmaGrid extends AbstractModel implements IdentityInterface
{
    /** @var string */
    const CACHE_TAG = 'filoblu_rma_rma';
    /** @var string */
    protected $_cacheTag = 'filoblu_rma_rma';
    /** @var string */
    protected $_eventPrefix = 'filoblu_rma_rma';

    /**
     * @return string[]
     */
    public function getIdentities()
    {
        return [self::CACHE_TAG . '_' . $this->getId()];
    }

    /**
     * @return array
     */
    public function getDefaultValues()
    {
        return [];
    }

    /**
     * @return void
     */
    protected function _construct()
    {
        $this->_init(ResourceModel\RmaGrid::class);
    }

}
