<?php
/**
 * Created by PhpStorm.
 * User: jderosa
 * Date: 26/06/19
 * Time: 12.53
 */

namespace FiloBlu\Rma\Model\ResourceModel\RmaGrid;

use FiloBlu\Rma\Model\RmaGrid;
use Magento\Framework\Data\Collection\Db\FetchStrategyInterface;
use Magento\Framework\Data\Collection\EntityFactoryInterface;
use Magento\Framework\DB\Adapter\AdapterInterface;
use Magento\Framework\DB\Select;
use Magento\Framework\Event\ManagerInterface;
use Magento\Framework\Model\ResourceModel\Db\AbstractDb;
use Magento\Framework\Model\ResourceModel\Db\Collection\AbstractCollection;
use Psr\Log\LoggerInterface;
use Zend_Db_Select;

/**
 *
 */
class Collection extends AbstractCollection
{

    /** @var string */
    protected $_eventPrefix = 'filoblu_rma_rmaGrid_grid_collection';
    /** @var string */
    protected $_eventObject = 'filoblu_rma_rmaGrid_collection';


    /**
     * Collection constructor.
     * @param EntityFactoryInterface $entityFactory
     * @param LoggerInterface $logger
     * @param FetchStrategyInterface $fetchStrategy
     * @param ManagerInterface $eventManager
     * @param AdapterInterface|null $connection
     * @param AbstractDb|null $resource
     */
    public function __construct(
        EntityFactoryInterface $entityFactory,
        LoggerInterface        $logger,
        FetchStrategyInterface $fetchStrategy,
        ManagerInterface       $eventManager,
        AdapterInterface       $connection = null,
        AbstractDb             $resource = null
    )
    {
        $this->_init(RmaGrid::class, \FiloBlu\Rma\Model\ResourceModel\RmaGrid::class);
        parent::__construct($entityFactory, $logger, $fetchStrategy, $eventManager, $connection, $resource);
    }

    /**
     * @return Select
     */
    public function getSelectCountSql()
    {
        $countSelect = parent::getSelectCountSql();
        $countSelect->reset(Zend_Db_Select::GROUP);
        return $countSelect;
    }

    /**
     * @param $field
     * @param null $condition
     * @return $this
     */
    public function addFieldToSearchFilter($field, $condition = null)
    {
        $field = $this->_getMappedField($field);
        $this->_select->orWhere($this->_getConditionSql($field, $condition));
        return $this;
    }

    /**
     * @return void
     */
    protected function _initSelect()
    {
        $this->addFilterToMap('status', 'main_table.status');
        $this->addFilterToMap('grid_entity_id', 'magento_rma_grid.entity_id');
        $this->addFilterToMap('entity_id', 'main_table.entity_id');
        parent::_initSelect()
            ->addFieldToSelect(['status', 'comment', 'created_at', 'rma_entity_id'])
            ->getSelect()
            ->joinLeft(
                ['magento_rma_grid' => $this->getTable('magento_rma_grid')],
                'main_table.rma_entity_id = magento_rma_grid.entity_id',
                [
                    'grid_entity_id'     => 'magento_rma_grid.entity_id',
                    'order_id'           => 'magento_rma_grid.order_id',
                    'order_increment_id' => 'magento_rma_grid.order_increment_id',
                    'customer_name'      => 'magento_rma_grid.customer_name'

                ]
            );
    }

    /**
     * @param $valueField
     * @param $labelField
     * @param $additional
     * @return array
     */
    protected function _toOptionArray($valueField = 'entity_id', $labelField = 'entity_id', $additional = [])
    {
        return parent::_toOptionArray($valueField, $labelField, $additional);
    }

}
