<?php

namespace FiloBlu\Rma\Model\Config\Source;

use Magento\Framework\Data\OptionSourceInterface;
use Magento\Framework\Module\Manager;

/**
 *
 */
class MatrixrateSource implements OptionSourceInterface
{
    /**
     * @var Manager
     */
    private $moduleManager;

    /**
     * @param Manager $moduleManager
     */
    public function __construct(
        Manager $moduleManager
    )
    {
        $this->moduleManager = $moduleManager;
    }

    /**
     * Return array of options as value-label pairs
     *
     * @return array Format: array(array('value' => '<value>', 'label' => '<label>'), ...)
     */
    public function toOptionArray()
    {
        $options = [
            [
                'value' => 'filoblu_easy_return_matrixrate',
                'label' => __('FiloBlu Easy Return EasyReturnRate')
            ],
            [
                'value' => 'filoblu_change_size_matrixrate',
                'label' => __('FiloBlu Change Size EasyReturnRate')
            ]
        ];

        if ($this->moduleManager->isEnabled('WebShopApps_MatrixRate')) {
            $options[] = [
                'value' => 'webshopapps_matrixrate',
                'label' => __('Webshoapps EasyReturnRate')
            ];
        }

        return $options;
    }
}
