<?php

/**
 * Created by PhpStorm.
 * User: jderosa
 * Date: 14/02/20
 * Time: 16.52
 */

namespace FiloBlu\Rma\Block\Rma\Returns;

use Magento\Eav\Model\Config;
use Magento\Eav\Model\Form\Factory;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\Data\Collection\ModelFactory;
use Magento\Framework\View\Element\Template\Context;
use Magento\Rma\Block\Form;
use Magento\Store\Model\ScopeInterface;

/**
 *
 */
class View extends Form
{
    /** @var string */
    const ADDIONAL_RMA_TEXT = 'filoblu_disablerma_section/rma_additional_text_group/rma_additional_text';

    /** @var string */
    const ADDIONAL_RMA_TEXT_ENABLE = 'filoblu_disablerma_section/rma_additional_text_group/rma_additional_text_enable';

    /**
     * @var ScopeConfigInterface
     */
    protected $scopeConfig;

    /**
     * View constructor.
     * @param Context $context
     * @param ModelFactory $modelFactory
     * @param Factory $formFactory
     * @param Config $eavConfig
     * @param array $data
     */
    public function __construct(
        Context $context,
        ModelFactory $modelFactory,
        Factory $formFactory,
        Config $eavConfig,
        array $data = []
    ) {
        parent::__construct(
            $context,
            $modelFactory,
            $formFactory,
            $eavConfig,
            $data
        );
        $this->scopeConfig = $context->getScopeConfig();
    }

    /**
     * @return string
     */
    public function getAdditionalText()
    {
        if ($this->scopeConfig->getValue(self::ADDIONAL_RMA_TEXT_ENABLE, ScopeInterface::SCOPE_STORE)) {
            return $this->scopeConfig->getValue(self::ADDIONAL_RMA_TEXT, ScopeInterface::SCOPE_STORE) ?? '';
        }

        return '';
    }
}
