<?php

namespace FiloBlu\Rma\Block\Adminhtml\Order\View\Tab;

use Magento\Backend\Block\Template\Context;
use Magento\Directory\Helper\Data as DirectoryHelper;
use Magento\Framework\Json\Helper\Data as JsonHelper;
use Magento\Framework\Registry;
use Magento\Rma\Model\ResourceModel\Rma\CollectionFactory;

class ChangeSizeOrders extends \Magento\Backend\Block\Template implements \Magento\Backend\Block\Widget\Tab\TabInterface
{
    protected $_template = 'FiloBlu_Rma::order/view/tab/changesizeorders.phtml';
    /**
     * @var \Magento\Framework\Registry
     */
    private $registry;
    /**
     * @var \Magento\Rma\Model\ResourceModel\Rma\CollectionFactory
     */
    private $collectionFactory;

    /**
     * @param Context $context
     * @param Registry $registry
     * @param CollectionFactory $collectionFactory
     * @param array $data
     */
    public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        \Magento\Framework\Registry $registry,
        \Magento\Rma\Model\ResourceModel\Rma\CollectionFactory $collectionFactory,
        array $data = []
    )
    {
        $this->registry = $registry;
        parent::__construct($context, $data);
        $this->collectionFactory = $collectionFactory;
    }


    /**
     * Retrieve order model instance
     *
     * @return \Magento\Sales\Model\Order
     */
    public function getOrder()
    {
        return $this->registry->registry('current_order');
    }

    /**
     * Retrieve order model instance
     *
     * @return int
     *Get current id order
     */
    public function getOrderId()
    {
        return $this->getOrder()->getEntityId();
    }
    /**
     * Retrieve order increment id
     *
     * @return string
     */
    public function getOrderIncrementId()
    {
        return $this->getOrder()->getIncrementId();
    }
    /**
     * Retrieve order increment id
     *
     * @return string
     */
    public function getCustomerEmail()
    {
        return $this->getOrder()->getCustomerEmail();
    }


    public function getTabLabel()
    {
        return __('Change Size Orders');
    }

    public function getTabTitle()
    {
        return __('Change Size Orders');
    }

    public function canShowTab()
    {
        if (!$order = $this->getOrder()) {
            return false;
        }

        $collection = $this->collectionFactory->create();
        $connection = $collection->getConnection();
        $collection->addFieldToFilter('main_table.order_id', ['eq' => $order->getEntityId()]);

        $collection->join(
            ['mrie' => $connection->getTableName('magento_rma_item_entity') ],
            '`main_table`.entity_id = mrie.rma_entity_id'
        )
        ->join(
            ['fri' => $connection->getTableName('filoblu_rma_items') ],
            'mrie.entity_id = fri.rma_item_id'
        )
        ->join(
            ['so' => $connection->getTableName('sales_order')],
            'fri.order_id = so.entity_id'
        );

        return $collection->count();
    }

    public function isHidden()
    {
        return false;
    }
}
