<?php
/**
 * Created by PhpStorm.
 * User: jderosa
 * Date: 23/08/19
 * Time: 9.58
 */

namespace FiloBlu\Rma\Model\UiComponent\DataProvider;

use Magento\Framework\View\Element\UiComponent\DataProvider\DataProvider;
use Magento\Framework\Api\Search\SearchResultInterface;

/**
 *
 */
class RmaHistoryDataProvider extends DataProvider
{

    /**
     * @param SearchResultInterface $searchResult
     * @return array
     */
    protected function searchResultToOutput(SearchResultInterface $searchResult)
    {
        $arrItems = [];

        $arrItems['items'] = [];
        foreach ($searchResult->getItems() as $item) {
            $itemData = [];
            foreach ($item->getCustomAttributes() as $attribute) {
                $itemData[$attribute->getAttributeCode()] = $attribute->getValue();
            }
            $arrItems['items'][] = $itemData;
        }

        $arrItems['totalRecords'] = $searchResult->getTotalCount();

        return $this->addUniqueIndex($arrItems);
    }

    /**
     * @param array $arrItems
     * @return array
     */
    private function addUniqueIndex(array $arrItems)
    {
        $id = 0;
        $newItems = [];
        foreach ($arrItems['items'] as $items)
        {
            $items['id'] = $id;
            $id++;
            $newItems[]=$items;
        }
        $arrItems['items'] = $newItems;
        return $arrItems;
    }

}
