<?php

/**
 * Created by PhpStorm.
 * User: jderosa
 * Date: 24/02/20
 * Time: 8.22
 */

namespace FiloBlu\Rma\Model\Rma;

use Exception;
use FiloBlu\Rma\Api\RmaExtensionAttributesRepositoryInterface;
use Magento\Framework\App\ResourceConnection;
use Magento\Rma\Api\Data\ItemExtensionInterfaceFactory;
use Magento\Rma\Api\Data\ItemInterfaceFactory;
use Magento\Sales\Api\OrderRepositoryInterface;
use Psr\Log\LoggerInterface;

/**
 *
 */
class RmaExtensionAttributesRepository implements RmaExtensionAttributesRepositoryInterface
{
    /**
     * @var LoggerInterface
     */
    protected $logger;
    /**
     * @var OrderRepositoryInterface
     */
    private $orderRepository;
    /**
     * @var ItemExtensionInterfaceFactory
     */
    private $extensionInterfaceFactory;
    /**
     * @var ResourceConnection
     */
    private $resourceConnection;
    /**
     * @var ItemInterfaceFactory
     */
    private $itemFactory;

    /**
     * RmaExtensionAttributesRepository constructor.
     * @param OrderRepositoryInterface $orderRepository
     * @param ItemExtensionInterfaceFactory $extensionInterfaceFactory
     * @param ResourceConnection $resourceConnection
     * @param LoggerInterface $logger
     * @param ItemInterfaceFactory $itemFactory
     */
    public function __construct(
        OrderRepositoryInterface $orderRepository,
        ItemExtensionInterfaceFactory $extensionInterfaceFactory,
        ResourceConnection $resourceConnection,
        LoggerInterface $logger,
        ItemInterfaceFactory $itemFactory
    ) {
        $this->orderRepository = $orderRepository;
        $this->extensionInterfaceFactory = $extensionInterfaceFactory;
        $this->resourceConnection = $resourceConnection;
        $this->logger = $logger;
        $this->itemFactory = $itemFactory;
    }

    /**
     * @param int $rmaItemId
     * @param int $orderId
     * @return bool
     */
    public function setChangeSizeOrderId(int $rmaItemId, int $orderId)
    {
        try {
            if (!$this->orderRepository->get($orderId)) {
                $this->logger->critical("RmaExtensionAttributesRepository->no such entity orderId = $orderId");
                return false;
            }
            if (!$this->itemFactory->create()->setEntityId($rmaItemId)) {
                $this->logger->critical("RmaExtensionAttributesRepository->no such entity rmaItemId = $rmaItemId");
                return false;
            }

            if (!$this->getChangeSizeOrderId($rmaItemId)) {
                $connection = $this->resourceConnection->getConnection();
                $table = $connection->getTableName(self::TABLE_NAME);
                $connection->query(
                    "INSERT INTO {$table} (rma_item_id,order_id) VALUES (:rmaItemId,:orderId) ON DUPLICATE KEY UPDATE rma_item_id = :rmaItemId, order_id = :orderId",
                    ['rmaItemId' => $rmaItemId, 'orderId' => $orderId]
                );
                return true;
            }
        } catch (Exception $e) {
            $this->logger->critical($e->getMessage(), ['exception' => $e]);
        }

        return false;
    }

    /**
     * @param int $rmaItemId
     * @param int|null $orderId
     * @return array
     */
    public function getChangeSizeOrderId(int $rmaItemId)
    {
        if ($rmaItemId) {
            try {
                $connection = $this->resourceConnection->getConnection();
                $table = $connection->getTableName(self::TABLE_NAME);
                $row = $connection->fetchRow("SELECT * FROM $table WHERE rma_item_id = :id", ['id' => $rmaItemId]);
                if ($row) {
                    return $row['order_id'];
                }
            } catch (Exception $e) {
                $this->logger->critical($e->getMessage(), ['exception' => $e]);
            }
        } else {
            $this->logger->critical("RmaExtensionAttributesRepository->missing parameters values rmaItemId = $rmaItemId");
        }

        return false;

    }

    /**
     * @param $rmaType
     * @return void
     */
    public function setRmaType($rmaType)
    {
        // TODO: Implement setRmaType() method.
    }

    /**
     * @return void
     */
    public function getRmaType()
    {

    }
}
