<?php
/**
 * Created by PhpStorm.
 * User: jderosa
 * Date: 21/04/20
 * Time: 11.53
 */

namespace FiloBlu\Rma\Handlers;

use FiloBlu\Rma\Model\RmaEmailManagment;
use Magento\Rma\Model\Rma;

/**
 *
 */
class RmaEmailHandler
{
    /**
     * @var RmaEmailManagment
     */
    private $rmaEmailManagement;

    /**
     * RmaEmailHandler constructor.
     * @param RmaEmailManagment $rmaEmailManagement
     */
    public function __construct(RmaEmailManagment $rmaEmailManagement)
    {
        $this->rmaEmailManagement = $rmaEmailManagement;
    }

    /**
     * @param \Magento\Rma\Model\Rma $subject
     * @return void
     */
    public function sendRmaEmail(Rma $subject)
    {
        $this->rmaEmailManagement->checkIfSendRmaEmail($subject);
    }

    public function sendWrongOrDamagedRmaEmail(Rma $subject)
    {
        $this->rmaEmailManagement->sendWrongOrDamagedRmaEmail($subject);
    }
}
