<?php

namespace FiloBlu\Rma\Model\Config\Backend;

use FiloBlu\Rma\Model\ResourceModel\Carrier\RateFactory;
use Magento\Framework\App\Cache\TypeListInterface;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\Config\Value;
use Magento\Framework\Data\Collection\AbstractDb;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Model\Context;
use Magento\Framework\Model\ResourceModel\AbstractResource;
use Magento\Framework\Registry;

/**
 *
 */
class EasyReturnRate extends Value
{
    /**
     * @var \FiloBlu\Rma\Model\ResourceModel\Carrier\RateFactory
     */
    protected $matrixRateFactoryInterface;

    /**
     * @param \Magento\Framework\Model\Context $context
     * @param \Magento\Framework\Registry $registry
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $config
     * @param \Magento\Framework\App\Cache\TypeListInterface $cacheTypeList
     * @param \FiloBlu\Rma\Model\ResourceModel\Carrier\RateFactory $easyReturnRateFactory
     * @param \Magento\Framework\Model\ResourceModel\AbstractResource|null $resource
     * @param \Magento\Framework\Data\Collection\AbstractDb|null $resourceCollection
     * @param array $data
     */
    public function __construct(
        Context $context,
        Registry $registry,
        ScopeConfigInterface $config,
        TypeListInterface $cacheTypeList,
        RateFactory $easyReturnRateFactory,
        AbstractResource $resource = null,
        AbstractDb $resourceCollection = null,
        array $data = []
    ) {
        parent::__construct(
            $context,
            $registry,
            $config,
            $cacheTypeList,
            $resource,
            $resourceCollection,
            $data
        );
        $this->matrixRateFactoryInterface = $easyReturnRateFactory;
    }

    /**
     * @return Value
     * @throws LocalizedException
     */
    public function afterSave()
    {
        /** @var \FiloBlu\Rma\Model\ResourceModel\Carrier\EasyReturnRate $matrixRate */
        $matrixRate = $this->matrixRateFactoryInterface->create();
        $matrixRate->uploadAndImport($this);
        return parent::afterSave();
    }
}
