<?php

namespace FiloBlu\Rma\Block\Adminhtml\System\Config;


use Magento\Backend\Block\Template\Context;
use Magento\Config\Block\System\Config\Form\Field\FieldArray\AbstractFieldArray;
use Magento\Eav\Model\Config;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\View\Element\Html\Select;

class WrongSizeMapping extends AbstractFieldArray
{
    /**
     * @var Config
     */
    private $eavConfig;

    /**
     * @param Context $context
     * @param Config $eavConfig
     * @param array $data
     */
    public function __construct(
        Context $context,
        \Magento\Eav\Model\Config $eavConfig,
        array $data = []
    )
    {
        parent::__construct($context, $data);
        $this->eavConfig = $eavConfig;
    }

    /**
     * @var array
     */
    protected $brandReasons;

    /**
     * @var array
     */
    protected $magentoReasons;

    /**
     * Prepare rendering the new field by adding all the needed columns
     *
     * @throws LocalizedException
     */
    protected function _prepareToRender()
    {
        $this->addColumn(
            'magento_reason',
            [
                'label' => __('Magento Reason'),
                'renderer' => $this->_getMagentoReasonsRender(),
            ]
        );
        $this->addColumn(
            'brand_reason',
            [
                'label' => __('Brand Reason'),
                'renderer' => $this->_getBrandReasonsRender(),
            ]
        );

        $this->_addAfter = false;
        $this->_addButtonLabel = __('Add reason to map');
    }

    private function _getBrandReasonsRender()
    {
        if (!$this->brandReasons) {
            $this->brandReasons = $this->getLayout()->createBlock(
                Select::class
            );
        }

        $options = [
            [
                'value' => 'too_small',
                'label' => __('too_small')
            ],
            [
                'value' => 'too_big',
                'label' => __('too_big')
            ]
        ];

        array_unshift($options, ['value' => '*', 'label' => __('-- Select --')]);


        $this->brandReasons->setOptions($options);
        $this->brandReasons
            ->setId($this->_getCellInputElementId('<%- _id %>', 'brand_reason'))
            ->setName($this->_getCellInputElementName('brand_reason'));

        return $this->brandReasons;
    }


    private function _getMagentoReasonsRender()
    {
        if (!$this->magentoReasons) {
            $this->magentoReasons = $this->getLayout()->createBlock(
                Select::class
            );
        }

        $attribute = $this->eavConfig->getAttribute('rma_item', 'reason');
        $options = $attribute->getSource()->getAllOptions();

        array_unshift($options, ['value' => '*', 'label' => __('-- Select --')]);

        $this->magentoReasons->setOptions($options);
        $this->magentoReasons
            ->setId($this->_getCellInputElementId('<%- _id %>', 'magento_reason'))
            ->setName($this->_getCellInputElementName('magento_reason'));

        return $this->magentoReasons;
    }

}
