<?php

namespace FiloBlu\Rma\Block\Adminhtml\System\Config;

use Magento\Backend\Block\Template\Context;
use Magento\Catalog\Model\ResourceModel\Product\Attribute\CollectionFactory;
use Magento\Config\Block\System\Config\Form\Field\FieldArray\AbstractFieldArray;
use Magento\Eav\Model\Config;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\View\Element\Html\Select;


/**
 *
 */
class CustomSizeValueLabel extends AbstractFieldArray
{

    /**
     * @var Config $eavConfig ,
     */
    protected $eavConfig;
    /**
     * @var CollectionFactory
     */
    private $collectionFactory;

    /**
     * @param Context $context
     * @param CollectionFactory $collectionFactory
     * @param array $data
     */
    public function __construct(
        Context $context,
        CollectionFactory $collectionFactory,
        array $data = []
    )
    {
        $this->collectionFactory = $collectionFactory;
        parent::__construct($context, $data);
    }


    /**
     * @throws LocalizedException
     */
    protected function _prepareToRender()
    {
        $attributeToOverride = $this->getLayout()->createBlock(Select::class)
            ->setId($this->_getCellInputElementId('<%- _id %>', 'attribute_to_override'))
            ->setName($this->_getCellInputElementName('attribute_to_override'))
            ->setClass('select')
            ->setOptions($this->getAttributeOptions(['size', 'color']));

        $attributeToShow = $this->getLayout()->createBlock(Select::class)
            ->setId($this->_getCellInputElementId('<%- _id %>', 'attribute_to_show'))
            ->setName($this->_getCellInputElementName('attribute_to_show'))
            ->setClass('select')
            ->setOptions($this->getAttributeOptions());

        $this->addColumn('attribute_to_override', [
            'label' => __('Attribute to override'),
            'renderer' => $attributeToOverride
        ]);

        $this->addColumn('attribute_to_show', [
            'label' => __('Attribute to show'),
            'renderer' => $attributeToShow
        ]);

        $this->_addAfter = false;
        $this->_addButtonLabel = __('Add Attribute to map');
    }

    public function getAttributeOptions($filters = [])
    {
        $attributes = $this->collectionFactory->create()->getItems();
        $options = [];

        foreach ($attributes as $attribute) {
            if (!$filters){
                $options[] = [
                    'value' => $attribute->getAttributeCode(),
                    'label' => $attribute->getDefaultFrontendLabel(),
                ];
                continue;
            }
            if(in_array($attribute->getAttributeCode(), $filters)){
                $options[] = [
                    'value' => $attribute->getAttributeCode(),
                    'label' => $attribute->getDefaultFrontendLabel(),
                ];
            }
        }
        return $options;
    }
}
