<?php
/**
 * Copyright © 2019 Filoblu S.r.l. All rights reserved.
 */

namespace FiloBlu\Rma\Api\Model\Config;

use Magento\Framework\Config\Dom;
use Magento\Framework\Config\FileResolverInterface;
use Magento\Framework\Config\Reader\Filesystem;
use Magento\Framework\Config\ValidationStateInterface;

/**
 *
 */
class Reader extends Filesystem
{

    protected $_idAttributes = [
        '/rma_reason/standard_name' => 'standard_name',
        '/rma_reason/id'            => 'id'
    ];

    /**
     * @param FileResolverInterface $fileResolver
     * @param Converter $converter
     * @param SchemaLocator $schemaLocator
     * @param ValidationStateInterface $validationState
     * @param string $fileName
     * @param array $idAttributes
     * @param string $domDocumentClass
     * @param string $defaultScope
     */

    public function __construct(
        FileResolverInterface    $fileResolver,
        Converter                $converter,
        SchemaLocator            $schemaLocator,
        ValidationStateInterface $validationState,
                                 $fileName = 'rma_reasons.xml',
                                 $idAttributes = [],
                                 $domDocumentClass = Dom::class,
                                 $defaultScope = 'global'
    )
    {
        parent::__construct(
            $fileResolver,
            $converter,
            $schemaLocator,
            $validationState,
            $fileName,
            $idAttributes,
            $domDocumentClass,
            $defaultScope
        );
    }
}
