<?php
/**
 * Created by PhpStorm.
 * User: jderosa
 * Date: 06/08/19
 * Time: 15.11
 */

namespace FiloBlu\Rma\Ui\Component\Listing\Columns;

use Magento\Backend\Model\UrlInterface;
use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Magento\Framework\View\Element\UiComponentFactory;
use Magento\Ui\Component\Listing\Columns\Column;

/**
 *
 */
class OrderAction extends Column
{
    /**
     * @var UrlInterface
     */
    protected $urlBuilder;

    /**
     * OrderAction constructor.
     * @param ContextInterface $context
     * @param UiComponentFactory $uiComponentFactory
     * @param UrlInterface $urlBuilder
     * @param array $components
     * @param array $data
     */
    public function __construct(ContextInterface   $context,
                                UiComponentFactory $uiComponentFactory,
                                UrlInterface       $urlBuilder,
                                array              $components = [],
                                array              $data = [])
    {
        parent::__construct($context, $uiComponentFactory, $components, $data);
        $this->urlBuilder = $urlBuilder;
    }

    /**
     * @param array $dataSource
     * @return array
     */
    public function prepareDataSource(array $dataSource)
    {
        if (isset($dataSource['data']['items'])) {
            foreach ($dataSource['data']['items'] as &$item) {
                if (isset($item['order_id']) && isset($item['order_increment_id'])) {
                    $item[$this->getData('name')] =
                        [
                            $item['order_increment_id'] =>
                                [
                                    'href'   => $this->urlBuilder->getUrl(
                                        'sales/order/view',
                                        [
                                            'order_id' => $item['order_id']
                                        ]
                                    ),
                                    'target' => '_blank',
                                    'label'  => $item['order_increment_id']
                                ]

                        ];
                }
            }
        }
        return $dataSource;
    }

}
