<?php

require __DIR__ . '/../../../../../app/bootstrap.php';

use Magento\Framework\App\Area;
use Magento\Framework\App\Bootstrap;
use Magento\Framework\App\State;
use Magento\Rma\Model\ItemFactory;
use Magento\Sales\Api\OrderRepositoryInterface;
use Magento\Store\Model\App\Emulation;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Sales\Model\OrderFactory;
use Magento\Rma\Model\RmaFactory;
use FiloBlu\Rma\Plugin\Model\RmaModelRmaProcessor;
use const Filoblu\Storelocator\Model\Rma\ItemFactory;

$bootstrap = Bootstrap::create(BP, $_SERVER);

$objectManager = $bootstrap->getObjectManager();

/** @var State $state */
$state = $objectManager->get(State::class);
$state->setAreaCode(\Magento\Framework\App\Area::AREA_FRONTEND);

$helper = $objectManager->get(\FiloBlu\Rma\Helper\EasyReturnHelper::class);

/** @var OrderRepositoryInterface $orderRepository */
$orderRepository = $objectManager->get(OrderRepositoryInterface::class);

$order = $orderRepository->get(221724);

$address = $order->getShippingAddress();

$shippingCost = $helper->simulateEasyReturnShippingCost(
    $address,
    $order->getStore(),
    0.2,
    $order->getGrandTotal(),
    22,
    'price'
);
