<?php

/**
 * Created by PhpStorm.
 * User: jderosa
 * Date: 05/03/20
 * Time: 9.25
 */

namespace FiloBlu\Rma\Model\Order\Email\Container;

use Magento\Sales\Model\Order\Email\Container\Container;
use Magento\Sales\Model\Order\Email\Container\IdentityInterface;
use Magento\Store\Model\ScopeInterface;

/**
 *
 */
class ChangeSizeOrderIdentity extends Container implements IdentityInterface
{
    /**
     * Configuration paths
     */
    const XML_PATH_EMAIL_COPY_METHOD = 'sales_email/filoblu_extrma_email_order_changesize/copy_method';
    const XML_PATH_EMAIL_COPY_TO = 'sales_email/filoblu_extrma_email_order_changesize/copy_to';
    const XML_PATH_EMAIL_IDENTITY = 'sales_email/filoblu_extrma_email_order_changesize/identity';
    const XML_PATH_EMAIL_GUEST_TEMPLATE = 'sales_email/filoblu_extrma_email_order_changesize/guest_template';
    const XML_PATH_EMAIL_TEMPLATE = 'sales_email/filoblu_extrma_email_order_changesize/template';
    const XML_PATH_EMAIL_ENABLED = 'sales_email/filoblu_extrma_email_order_changesize/enabled';

    /**
     * @return bool
     */
    public function isEnabled()
    {
        return $this->scopeConfig->isSetFlag(self::XML_PATH_EMAIL_ENABLED, ScopeInterface::SCOPE_STORE, $this->getStore());
    }

    /**
     * Return email copy_to list
     *
     * @return array|bool
     */
    public function getEmailCopyTo()
    {
        $data = $this->getConfigValue(self::XML_PATH_EMAIL_COPY_TO, $this->getStore()->getStoreId());
        if (!empty($data)) {
            return explode(',', $data);
        }
        return false;
    }

    /**
     * Return copy method
     *
     * @return mixed
     */
    public function getCopyMethod()
    {
        return $this->getConfigValue(self::XML_PATH_EMAIL_COPY_METHOD, $this->getStore()->getStoreId());
    }

    /**
     * Return guest template id
     *
     * @return mixed
     */
    public function getGuestTemplateId()
    {
        return $this->getConfigValue(self::XML_PATH_EMAIL_GUEST_TEMPLATE, $this->getStore()->getStoreId());
    }

    /**
     * Return template id
     *
     * @return mixed
     */
    public function getTemplateId()
    {
        return $this->getConfigValue(self::XML_PATH_EMAIL_TEMPLATE, $this->getStore()->getStoreId());
    }

    /**
     * Return email identity
     *
     * @return mixed
     */
    public function getEmailIdentity()
    {
        return $this->getConfigValue(self::XML_PATH_EMAIL_IDENTITY, $this->getStore()->getStoreId());
    }
}
