<?php

namespace FiloBlu\Rma\Model;

use FiloBlu\Rma\Api\Data\ChangeSizeItemsInterface;
use Magento\Framework\Model\AbstractModel;

class ChangeSizeItems extends AbstractModel implements ChangeSizeItemsInterface
{
    protected function _construct()
    {
        $this->_init(\FiloBlu\Rma\Model\ResourceModel\ChangeSizeItems::class);
    }

    public function getParentOrderId()
    {
        return $this->getData(self::PARENT_ORDER_ID);
    }

    public function setParentOrderId($parentOrderId)
    {
        $this->setData(self::PARENT_ORDER_ID, $parentOrderId);
        return $this;
    }

    public function getParentOrderIncrementId()
    {
        return $this->getData(self::PARENT_ORDER_INCREMENT_ID);
    }

    public function setParentOrderIncrementId($parentIncrementId)
    {
        $this->setData(self::PARENT_ORDER_INCREMENT_ID, $parentIncrementId);
        return $this;
    }

    public function getRmaId()
    {
        return $this->getData(self::RMA_ID);
    }

    public function setRmaId($rmaId)
    {
        $this->setData(self::RMA_ID, $rmaId);
        return $this;
    }

    public function getRmaIncrementId()
    {
        return $this->getData(self::RMA_INCREMENT_ID);
    }

    public function setRmaIncrementId($rmaIncrementId)
    {
        $this->setData(self::RMA_INCREMENT_ID, $rmaIncrementId);
        return $this;
    }

    public function getParentOrderItem()
    {
        return $this->getData(self::PARENT_ORDER_ITEM);
    }

    public function setParentOrderItem($parentOrderItem)
    {
        $this->setData(self::PARENT_ORDER_ITEM, $parentOrderItem);
        return $this;
    }

    public function getParentProductSku()
    {
        return $this->getData(self::PARENT_PRODUCT_SKU);
    }

    public function setParentProductSku($parentProductSku)
    {
        $this->setData(self::PARENT_PRODUCT_SKU, $parentProductSku);
        return $this;
    }

    public function getNewProductSku()
    {
        return $this->getData(self::PARENT_PRODUCT_SKU);
    }

    public function setNewProductSku($newProductSku)
    {
        $this->setData(self::PARENT_PRODUCT_SKU, $newProductSku);
        return $this;
    }

    public function getIsEasyReturn()
    {
        return $this->getData(self::IS_EASY_RETURN);
    }

    public function setIsEasyReturn($isEasyReturn)
    {
        $this->setData(self::IS_EASY_RETURN, $isEasyReturn);
        return $this;
    }

    public function getRmaItemId()
    {
        return $this->getData(self::RMA_ITEM_ID);
    }

    public function setRmaItemId($rmaItemId)
    {
        $this->setData(self::RMA_ITEM_ID, $rmaItemId);
        return $this;
    }

    public function getChangeSizeOrderId()
    {
        return $this->getData(self::CHANGE_SIZE_ORDER_ID);
    }

    public function setChangeSizeOrderId($changeSizeOrderId)
    {
        $this->setData(self::CHANGE_SIZE_ORDER_ID, $changeSizeOrderId);
        return $this;
    }

    public function getChangeSizeOrderIncrementId()
    {
        return $this->getData(self::CHANGE_SIZE_ORDER_INCREMENT_ID);
    }

    public function setChangeSizeOrderIncrementId($changeSizeOrderIncrementId)
    {
        $this->setData(self::CHANGE_SIZE_ORDER_INCREMENT_ID, $changeSizeOrderIncrementId);
        return $this;
    }
}
