<?php

namespace FiloBlu\Rma\Block\Adminhtml\System\Config;

use Magento\Backend\Block\Template\Context;
use Magento\Config\Block\System\Config\Form\Field\FieldArray\AbstractFieldArray;
use Magento\Eav\Model\Config;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\View\Element\Html\Select;
use Magento\Sales\Model\ResourceModel\Order\Status\Collection;

/**
 *
 */
class OrderStatus extends AbstractFieldArray
{
    /**
     * @var Config $eavConfig ,
     */
    protected $eavConfig;

    /**
     * @var Collection
     */
    private $orderStatusCollection;

    /**
     * OrderStatus constructor.
     * @param Config $eavConfig
     * @param Context $context
     * @param Collection $orderStatusCollection
     * @param array $data
     */
    public function __construct(
        Config     $eavConfig,
        Context    $context,
        Collection $orderStatusCollection,
        array      $data = []
    )
    {
        parent::__construct($context, $data);
        $this->orderStatusCollection = $orderStatusCollection;
        $this->eavConfig = $eavConfig;
    }

    /**
     * @throws LocalizedException
     */
    protected function _prepareToRender()
    {
        $orderStatus = $this->orderStatusCollection->toOptionArray();

        array_unshift($orderStatus, ['value' => '*', 'label' => __('-- Select --')]);

        $orderStatusBlock = $this->getLayout()
            ->createBlock(Select::class)
            ->setId($this->_getCellInputElementId('<%- _id %>', 'allowed_status'))
            ->setName($this->_getCellInputElementName('allowed_status'))
            ->setClass('select')
            ->setOptions($orderStatus);

        $this->addColumn('allowed_status', [
            'label'    => __('Magento Order Status'),
            'renderer' => $orderStatusBlock
        ]);

        $this->_addAfter = false;
        $this->_addButtonLabel = __('Add new allowed order status');
    }

}
