<?php

namespace FiloBlu\Rma\Block\Adminhtml\Rma\Grid;

use FiloBlu\Rma\Helper\ChangeSizeAttributeHelper;
use Magento\Backend\Block\Template\Context;
use Magento\Backend\Model\Url;
use Magento\Framework\App\Request\Http;
use Magento\Sales\Api\OrderRepositoryInterface;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Backend\Helper\Data as BackendHelper;

class Js extends \Magento\Backend\Block\Template
{
    /**
     * @var \FiloBlu\Rma\Helper\ChangeSizeAttributeHelper
     */
    private $changeSizeAttributeHelper;
    /**
     * @var \Magento\Framework\App\Request\Http
     */
    private $request;
    /**
     * @var OrderRepositoryInterface
     */
    private $orderRepository;
    /**
     * @var StoreManagerInterface
     */
    private $storeManager;
    /**
     * @var \Magento\Backend\Model\Url
     */
    private $backendUrlManager;

    /**
     * @param Context $context
     * @param ChangeSizeAttributeHelper $changeSizeAttributeHelper
     * @param Http $request
     * @param OrderRepositoryInterface $orderRepository
     * @param StoreManagerInterface $storeManager
     * @param Url $backendUrlManager
     * @param array $data
     */
    public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        \FiloBlu\Rma\Helper\ChangeSizeAttributeHelper $changeSizeAttributeHelper,
        \Magento\Framework\App\Request\Http $request,
        OrderRepositoryInterface $orderRepository,
        StoreManagerInterface $storeManager,
        \Magento\Backend\Model\Url $backendUrlManager,
        array $data = []
    )
    {
        parent::__construct($context, $data);
        $this->changeSizeAttributeHelper = $changeSizeAttributeHelper;
        $this->request = $request;
        $this->orderRepository = $orderRepository;
        $this->storeManager = $storeManager;
        $this->backendUrlManager = $backendUrlManager;
    }

    public function getChangeSizeAttributeOptionId()
    {
        return $this->changeSizeAttributeHelper->getChangeSizeAttributeOptionId();
    }

    public function getWebsiteId()
    {
        $orderId = $this->request->getParam('order_id');
        $order = $this->orderRepository->get($orderId);

        return $this->storeManager->getStore($order->getStoreId())->getWebsiteId();
    }

    public function getCustomUrl()
    {
        return $this->backendUrlManager->getUrl();
    }
}
