<?php

namespace FiloBlu\Rma\Plugin\Sales\Block\Order\Email;

use FiloBlu\Rma\Model\OrderLocator;

class Items
{
    /**
     * @var OrderLocator
     */
    private $orderLocator;

    /**
     * @param OrderLocator $orderLocator
     */
    public function __construct(
        OrderLocator $orderLocator
    )
    {
        $this->orderLocator = $orderLocator;
    }

    public function afterGetOrder($subject, $result)
    {
        if (!$result || !$result->getPayment()) {
            return $result;
        }

        if ($result->getPayment()->getMethod() == 'changesizepay') {
            $this->orderLocator->setCurrentOrder($result);
        }

        return $result;
    }
}
