<?php

/**
 * Created by PhpStorm.
 * User: jderosa
 * Date: 20/04/20
 * Time: 11.57
 */

namespace FiloBlu\Rma\Block\Returns;

use Exception;
use FiloBlu\Rma\Helper\EasyReturnHelper;
use Magento\Eav\Model\Config;
use Magento\Eav\Model\Form\Factory;
use Magento\Framework\Data\Collection\ModelFactory;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\Registry;
use Magento\Framework\View\Element\Template\Context;
use Magento\Rma\Helper\Data;
use Magento\Rma\Model\Item\FormFactory;
use Magento\Rma\Model\ItemFactory;
use Magento\Sales\Api\Data\OrderInterface;
use Magento\Sales\Model\Order\Address\Renderer;
use Magento\Store\Model\ScopeInterface;
use Throwable;

/**
 *
 */
class Form extends \Magento\Rma\Block\Returns\Create
{
    /**
     * @var EasyReturnHelper
     */
    private $easyReturnHelper;

    /**
     * Form constructor.
     * @param Context $context
     * @param ModelFactory $modelFactory
     * @param Factory $formFactory
     * @param Config $eavConfig
     * @param ItemFactory $itemFactory
     * @param FormFactory $itemFormFactory
     * @param Data $rmaData
     * @param Registry $registry
     * @param Renderer $addressRenderer
     * @param EasyReturnHelper $easyReturnHelper
     * @param array $data
     */
    public function __construct(
        Context $context,
        ModelFactory $modelFactory,
        Factory $formFactory,
        Config $eavConfig,
        ItemFactory $itemFactory,
        FormFactory $itemFormFactory,
        Data $rmaData,
        Registry $registry,
        Renderer $addressRenderer,
        EasyReturnHelper $easyReturnHelper,
        array $data = []
    ) {
        parent::__construct(
            $context,
            $modelFactory,
            $formFactory,
            $eavConfig,
            $itemFactory,
            $itemFormFactory,
            $rmaData,
            $registry,
            $addressRenderer,
            $data
        );
        $this->easyReturnHelper = $easyReturnHelper;
    }


    /**
     * @param OrderInterface $order
     * @return bool
     * @throws NoSuchEntityException
     */
    public function isRegionRequired(OrderInterface $order)
    {
        $storeId = $this->_storeManager->getStore()->getId();
        $country = $this->_scopeConfig->getValue('general/region/state_required', ScopeInterface::SCOPE_STORE, $storeId) ?? '';
        $myCountry = $order->getShippingAddress()->getCountryId();

        if (($country != '') && \in_array($myCountry, explode(',', $country))) {
            return true;
        }
        return false;
    }

    /**
     * @return bool
     */
    public function getIsEasyReturnEnabled()
    {
        try {
            return $this->easyReturnHelper->isEasyReturnEnabled($this->_storeManager->getStore()->getId());
        } catch (Exception $exception) {
            $this->_logger->critical($exception->getMessage(), ['exception' => $exception]);
            return false;
        } catch (Throwable $throwable) {
            $this->_logger->critical($throwable->getMessage(), ['exception' => $throwable]);
            return false;
        }
    }
}
