<?php

/**
 * Created by PhpStorm.
 * User: jderosa
 * Date: 25/02/20
 * Time: 14.21
 */

namespace FiloBlu\Rma\Block\Email;

use Exception;
use FiloBlu\Rma\Api\RmaExtensionAttributesRepositoryInterface;
use FiloBlu\Rma\Helper\ChangeSizeAttributeHelper;
use Magento\Catalog\Api\ProductRepositoryInterface;
use Magento\Eav\Model\Config;
use Magento\Eav\Model\Form\Factory;
use Magento\Framework\Data\Collection\ModelFactory;
use Magento\Framework\View\Element\Template\Context;
use Magento\Rma\Helper\Eav;
use Magento\Sales\Api\OrderRepositoryInterface;
use Throwable;

/**
 *
 */
class Items extends \Magento\Rma\Block\Email\Items
{
    /**
     * @var RmaExtensionAttributesRepositoryInterface
     */
    private $rmaExtensionAttributesRepository;

    /**
     * @var OrderRepositoryInterface
     */
    private $orderRepository;

    /**
     * @var ProductRepositoryInterface
     */
    private $productRepository;

    /**
     * @var ChangeSizeAttributeHelper
     */
    private $changeSizeAttributeHelper;


    /**
     * Items constructor.
     * @param Context $context
     * @param ModelFactory $modelFactory
     * @param Factory $formFactory
     * @param Config $eavConfig
     * @param Eav $rmaEav
     * @param RmaExtensionAttributesRepositoryInterface $rmaExtensionAttributesRepository
     * @param OrderRepositoryInterface $orderRepository
     * @param ProductRepositoryInterface $productRepository
     * @param ChangeSizeAttributeHelper $changeSizeAttributeHelper
     * @param array $data
     */
    public function __construct(
        Context $context,
        ModelFactory $modelFactory,
        Factory $formFactory,
        Config $eavConfig,
        Eav $rmaEav,
        RmaExtensionAttributesRepositoryInterface $rmaExtensionAttributesRepository,
        OrderRepositoryInterface $orderRepository,
        ProductRepositoryInterface $productRepository,
        ChangeSizeAttributeHelper $changeSizeAttributeHelper,
        array $data = []
    ) {
        parent::__construct($context, $modelFactory, $formFactory, $eavConfig, $rmaEav, $data);
        $this->rmaExtensionAttributesRepository = $rmaExtensionAttributesRepository;
        $this->orderRepository = $orderRepository;
        $this->productRepository = $productRepository;
        $this->changeSizeAttributeHelper = $changeSizeAttributeHelper;
    }

    /**
     * @param $myItem
     * @return array
     */
    public function getChangeSizeItems($myItem)
    {

        try {
            $resolution = $myItem->getResolution();
            $newSize = array_fill_keys(['label','value'], '');
            if ($this->changeSizeAttributeHelper->getChangeSizeAttributeOptionId() != $resolution) {
                return $newSize;
            }

            $changeSizeOrderId  = $this->rmaExtensionAttributesRepository->getChangeSizeOrderId($myItem->getEntityId());
            if ($changeSizeOrderId) {
                $changeSizeOrder = $this->orderRepository->get($changeSizeOrderId);
                $items = $changeSizeOrder->getItems();
                foreach ($items as $item) {
                    $product = $this->productRepository->get($item->getSku());
                    $newSize ['label'] = $item->getProduct()->getName() ?? $product->getName();
                    $newSize ['value'] = $product->getResource()->getAttribute('size')->getFrontend()->getValue($product);
                }
            }
            return $newSize;
        } catch (\Exception $e) {
            $this->_logger->critical($e->getMessage(), ['exception' => $e]);
            return array_fill_keys(['label','value'], '');
        } catch (\Throwable $t) {
            $this->_logger->critical($t->getMessage(), ['exception' => $t]);
            return array_fill_keys(['label','value'], '');
        }
    }
}
