<?php

namespace FiloBlu\Rma\Ui\Component\Listing\Columns\ResolutionHistory;

use FiloBlu\Rma\Helper\ChangeSizeAttributeHelper;
use Magento\Backend\Model\UrlInterface;
use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Magento\Framework\View\Element\UiComponentFactory;
use Magento\Rma\Api\RmaRepositoryInterface;
use Magento\Ui\Component\Listing\Columns\Column;

class Resolution extends Column
{
    /**
     * @var ChangeSizeAttributeHelper
     */
    protected $changeSizeAttributeHelper;

    /**
     * @param ContextInterface $context
     * @param UiComponentFactory $uiComponentFactory
     * @param ChangeSizeAttributeHelper $changeSizeAttributeHelper
     * @param array $components
     * @param array $data
     */
    public function __construct(
        ContextInterface $context,
        UiComponentFactory $uiComponentFactory,
        ChangeSizeAttributeHelper $changeSizeAttributeHelper,
        array $components = [],
        array $data = []
    )
    {
        parent::__construct($context, $uiComponentFactory, $components, $data);
        $this->changeSizeAttributeHelper = $changeSizeAttributeHelper;
    }

    public function prepareDataSource(array $dataSource)
    {
        if (isset($dataSource['data']['items'])) {
            foreach ($dataSource['data']['items'] as &$item) {

                $label = __('Return');

                if ((int)$this->changeSizeAttributeHelper->getChangeSizeAttributeOptionId() == (int)$item['resolution']) {
                    $label = __('Change Size');
                }

                $item[$this->getData('name')] = sprintf("%s - %s", (int)$item['resolution'], $label);
            }
        }

        return $dataSource;
    }
}
