<?php
/**
 * Created by PhpStorm.
 * User: jderosa
 * Date: 21/08/19
 * Time: 9.29
 */

namespace FiloBlu\Rma\Setup;
use Exception;
use Magento\Framework\Setup\InstallDataInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Symfony\Component\Console\Output\ConsoleOutput as Output;
use FiloBlu\Rma\Helper\InstallHelper;

/**
 * Class InstallData
 */
class InstallData implements InstallDataInterface
{

    /**
     * @var Output
     */
    protected $output;

    /**
     * @var InstallHelper
     */
    protected $installHelper;


    /**
     * InstallData constructor.
     * @param Output $output
     * @param InstallHelper $installHelper
     */
    public function __construct(Output $output, InstallHelper $installHelper) {
        $this->output = $output;
        $this->installHelper = $installHelper;
    }

    /**
     * Installs data for a module
     *
     * @param ModuleDataSetupInterface $setup
     * @param ModuleContextInterface $context
     *
     * @return void
     *
     * @throws Exception
     */
    public function install(ModuleDataSetupInterface $setup, ModuleContextInterface $context)
    {
        try
        {
            $this->installHelper->addNewOrderStatus($setup);
            $this->installHelper->addNewReasonOption($setup);
            $this->installHelper->addNewRmaItem($setup);
            $this->installHelper->hideReasonOther($setup);
            $this->installHelper->sortAttributes($setup);
            $this->installHelper->addWaitingFormRmaReceivingStatus($setup);

        }
        catch (\Exception $e)
        {
            $this->output->writeln("Error : ".$e->getMessage());
        }

    }




}
