<?php

namespace FiloBlu\Rma\Plugin\Sales\Block\Order;

use FiloBlu\Rma\Model\OrderLocator;

class Totals
{
    /**
     * @var OrderLocator
     */
    private $orderLocator;

    /**
     * @param OrderLocator $orderLocator
     */
    public function __construct(
        OrderLocator $orderLocator
    )
    {
        $this->orderLocator = $orderLocator;
    }

    public function afterGetOrder($subject, $result)
    {
        $changeSizeOrder = $this->orderLocator->hasOrder() ? $this->orderLocator->getCurrentOrder() : null;

        if (empty($changeSizeOrder)) {
            return $result;
        }

        return $changeSizeOrder;

    }
}
