<?php

namespace FiloBlu\Rma\Plugin\Rma\Block\Returns;

use FiloBlu\Rma\Helper\ReturnableProductHelper;

class Create
{
    /**
     * @var ReturnableProductHelper
     */
    private $returnableProductHelper;

    public function __construct(
        ReturnableProductHelper $returnableProductHelper
    )
    {
        $this->returnableProductHelper = $returnableProductHelper;
    }

    public function afterGetItems($subject, $result)
    {
        foreach ($result as $key => $item) {
            $product = $item->getProduct();

            if (!$this->returnableProductHelper->isProductReturnable($product, $item->getSku())) {
                unset($result[$key]);
            }
        }

        return $result;
    }
}