<?php

namespace FiloBlu\Rma\Plugin\Model\Payment;

use FiloBlu\Rma\Helper\RefundParentOrderHelper;
use FiloBlu\Rma\Model\Payment\ChangeSizePay;
use Magento\Payment\Model\InfoInterface;

class Kp
{
    /**
     * @var RefundParentOrderHelper
     */
    protected $refundOrderHelper;

    public function __construct(
        RefundParentOrderHelper  $refundOrderHelper
    )
    {
        $this->refundOrderHelper = $refundOrderHelper;
    }

    /**
     * @param \Klarna\Kp\Model\Payment\Kp $kp
     * @param InfoInterface $payment
     * @param float $amount
     * @return array|null
     */
    public function beforeRefund(
        \Klarna\Kp\Model\Payment\Kp $kp,
        InfoInterface               $payment,
                                    $amount)
    {
        if($payment->getMethod() == ChangeSizePay::PAYMENT_CODE && $this->refundOrderHelper->isOnlinePaymentRefundForParentEnabled()) {
            $parentOrderPayment = $this->refundOrderHelper->getParentOrderPayment($payment);
            if(!is_null($parentOrderPayment)) {
                if($this->refundOrderHelper->isOrderAllowedToRefund($payment, $parentOrderPayment)) {
                    return [$parentOrderPayment, $amount];
                }
            }
        }
        return null;
    }
}
