<?php

namespace FiloBlu\Rma\Model\Total\Quote;

use Magento\Customer\Model\Address\AbstractAddress;
use Magento\Payment\Model\MethodList;
use Magento\Quote\Model\Quote\Address\Total;
use Magento\Quote\Model\Quote\Address\Total\AbstractTotal;
use Magento\Quote\Api\Data\ShippingAssignmentInterface;
use Magento\Quote\Model\Quote;
use Magento\Quote\Model\Quote\Address;
use Magento\Quote\Api\Data\TotalsInterface;

/**
 *
 */
class CustomPrice extends AbstractTotal
{

    /**
     * @var MethodList
     */
    protected $methodList;

    /**
     * @var TotalsInterface
     */
    protected $totalsInterface;

    /**
     * @param MethodList $methodList
     * @param TotalsInterface $totalsInterface
     */
    public function __construct(
        MethodList $methodList,
        TotalsInterface $totalsInterface
    ) {
        $this->methodList = $methodList;
        $this->totalsInterface = $totalsInterface;
        $this->setCode('rma_customprice');
    }

    /**
     * TODO: ???? missing code?
     * @param Quote $quote
     * @param ShippingAssignmentInterface $shippingAssignment
     * @param Total $total
     * @return $this|CustomPrice
     */
    public function collect(
        Quote $quote,
        ShippingAssignmentInterface $shippingAssignment,
        Total $total
    ) {
        if ($shippingAssignment->getShipping()->getAddress()->getAddressType() != AbstractAddress::TYPE_SHIPPING
            || $quote->isVirtual()
        ) {
            return $this;
        }

        if($quote->getPayment()->getMethod() == 'changesizepay') {

            $info = $quote->getPayment()->getAdditionalInformation();
        }

        return $this;
    }

}
