<?php

namespace FiloBlu\ExtInventory\Plugin\Model;

use Magento\InventorySourceSelectionApi\Api\Data\InventoryRequestInterface;
use Magento\Sales\Api\OrderRepositoryInterface;
use Psr\Log\LoggerInterface;
use Throwable;

/**
 * Class GetInventoryRequestFromOrder
 * @package FiloBlu\ExtInventory\Plugin\Model
 */
class GetInventoryRequestFromOrder
{
    /**
     * @var OrderRepositoryInterface
     */
    protected $orderRepository;
    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * GetInventoryRequestFromOrder constructor.
     * @param LoggerInterface $logger
     * @param OrderRepositoryInterface $orderRepository
     */
    public function __construct(
        LoggerInterface $logger,
        OrderRepositoryInterface $orderRepository
    ) {
        $this->orderRepository = $orderRepository;
        $this->logger = $logger;
    }

    /**
     * @param \Magento\InventorySourceSelectionApi\Model\GetInventoryRequestFromOrder $subject
     * @param InventoryRequestInterface $result
     * @param int $orderId
     * @return InventoryRequestInterface
     */
    public function afterExecute(
        \Magento\InventorySourceSelectionApi\Model\GetInventoryRequestFromOrder $subject,
        $result,
        int $orderId
    ): InventoryRequestInterface {
        try {
            $result->getExtensionAttributes()->setOrder($this->orderRepository->get($orderId));
        } catch (Throwable $throwable) {
            $this->logger->error($throwable->getMessage(), ['exception' => $throwable]);
        }

        return $result;
    }
}
