<?php

namespace FiloBlu\ExtInventory\Plugin\Magento\Sales\Api;

use Exception;
use FiloBlu\ExtInventory\Api\Data\InventoryFbOrderItemSourceInterface;
use FiloBlu\ExtInventory\Api\Data\InventoryFbOrderItemSourceInterfaceFactory;
use FiloBlu\ExtInventory\Api\InventoryFbOrderItemSourceRepositoryInterface;
use FiloBlu\ExtInventory\Helper\Sources as HelperSources;
use FiloBlu\ExtInventory\Model\FinalSourceSelectionServiceInterface;
// Deprecated, SourceSlots\SourcesData has been removed
//use FiloBlu\ExtInventory\Model\ShippingAlgorithms\SourceSlots\Algorithm;
//use FiloBlu\ExtInventory\Model\ShippingAlgorithms\SourceSlots\SourcesData;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\DataObject;
use Magento\Framework\Event\ManagerInterface;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\InventorySales\Model\ResourceModel\StockIdResolver;
use Magento\InventorySalesApi\Api\Data\SalesChannelInterface;
use Magento\InventorySourceSelectionApi\Api\Data\AddressInterface;
use Magento\InventorySourceSelectionApi\Api\Data\AddressInterfaceFactory;
use Magento\InventorySourceSelectionApi\Api\Data\InventoryRequestExtensionInterfaceFactory;
use Magento\InventorySourceSelectionApi\Api\Data\InventoryRequestInterface;
use Magento\InventorySourceSelectionApi\Api\Data\InventoryRequestInterfaceFactory;
use Magento\InventorySourceSelectionApi\Api\Data\ItemRequestInterfaceFactory;
use Magento\InventorySourceSelectionApi\Api\Data\SourceSelectionResultInterface;
use Magento\InventorySourceSelectionApi\Api\SourceSelectionServiceInterface;
use Magento\Sales\Api\Data\OrderInterface;
use Magento\Sales\Api\OrderStatusHistoryRepositoryInterface;
use Magento\Sales\Model\Order\Address;
use Magento\Store\Model\ScopeInterface;
use Magento\Store\Model\StoreManagerInterface;
use Psr\Log\LoggerInterface;
use Throwable;

/**
 * Class OrderManagementInterface
 * @package FiloBlu\ExtInventory\Plugin\Magento\Sales\Api
 */
class OrderManagementInterface
{
    const XML_SOURCE_SELECTION_PATH = 'msi/sources/selection_algorithm';

    const XML_MSI_SOURCES_FINAL_SOURCE_SELECTION_ALGORITHM = 'msi/sources/final_source_selection_algorithm';

    //public $algorithm;
    //public $SourcesData;

    /**
     * @var InventoryFbOrderitemSourceInterface
     */
    public $InventoryFbOrderItemSourceInterface;
    /**
     * @var InventoryFbOrderItemSourceRepositoryInterface
     */
    public $InventoryFbOrderItemSourceRepositoryInterface;
    /**
     * @var array
     */
    public $sourcesListByCode;

    /**
     * @var HelperSources
     */
    public $helperSources;
    /**
     * @var StockIdResolver
     */
    private $stockIdResolver;
    /**
     * @var StoreManagerInterface
     */
    private $storeManager;
    /**
     * @var LoggerInterface
     */
    private $logger;
    /**
     * @var ScopeConfigInterface
     */
    private $scopeConfig;
    /**
     * @var ManagerInterface
     */
    private $eventManager;
    /**
     * @var SourceSelectionServiceInterface
     */
    private $sourceSelectionService;
    /**
     * @var InventoryRequestInterfaceFactory
     */
    private $inventoryRequestFactory;
    /**
     * @var ItemRequestInterfaceFactory
     */
    private $itemRequestFactory;
    /**
     * @var InventoryRequestExtensionInterfaceFactory
     */
    private $requestExtensionFactory;
    /**
     * @var InventoryFbOrderItemSourceInterfaceFactory
     */
    private $fbOrderitemSourceFactory;
    /**
     * @var OrderStatusHistoryRepositoryInterface
     */
    private $orderStatusHistoryRepository;
    /**
     * @var AddressInterfaceFactory
     */
    private $addressInterfaceFactory;
    /**
     * @var FinalSourceSelectionServiceInterface
     */
    private $finalSourceSelectionService;

    /**
     * OrderManagementInterface constructor.
     * @param InventoryFbOrderItemSourceRepositoryInterface $InventoryFbOrderItemSourceRepositoryInterface
     * @param InventoryFbOrderItemSourceInterface $InventoryFbOrderItemSourceInterface
     * @param StockIdResolver $stockIdResolver
     * @param StoreManagerInterface $storeManager
     * @param LoggerInterface $logger
     * @param ScopeConfigInterface $scopeConfig
     * @param HelperSources $helperSources
     * @param ManagerInterface $eventManager
     * @param SourceSelectionServiceInterface $sourceSelectionService
     * @param InventoryRequestInterfaceFactory $inventoryRequestFactory
     * @param ItemRequestInterfaceFactory $itemRequestFactory
     * @param InventoryRequestExtensionInterfaceFactory $requestExtensionFactory
     * @param InventoryFbOrderItemSourceInterfaceFactory $fbOrderitemSourceFactory
     * @param OrderStatusHistoryRepositoryInterface $orderStatusHistoryRepository
     * @param AddressInterfaceFactory $addressInterfaceFactory
     */
    public function __construct(InventoryFbOrderItemSourceRepositoryInterface                    $InventoryFbOrderItemSourceRepositoryInterface,
                                InventoryFbOrderItemSourceInterface                              $InventoryFbOrderItemSourceInterface,
                                StockIdResolver                                                  $stockIdResolver,
                                StoreManagerInterface                                            $storeManager,
                                //SourcesData                                                      $SourcesData,
                                //Algorithm                                                        $algorithm,
                                LoggerInterface                                                  $logger,
                                ScopeConfigInterface                                             $scopeConfig,
                                HelperSources                                                    $helperSources,
                                ManagerInterface                                                 $eventManager,
                                SourceSelectionServiceInterface                                  $sourceSelectionService,
                                InventoryRequestInterfaceFactory                                 $inventoryRequestFactory,
                                ItemRequestInterfaceFactory                                      $itemRequestFactory,
                                InventoryRequestExtensionInterfaceFactory                        $requestExtensionFactory,
                                InventoryFbOrderItemSourceInterfaceFactory                       $fbOrderitemSourceFactory,
                                OrderStatusHistoryRepositoryInterface                            $orderStatusHistoryRepository,
                                AddressInterfaceFactory                                          $addressInterfaceFactory,
                                FinalSourceSelectionServiceInterface $finalSourceSelectionService)
    {
        //$this->algorithm = $algorithm;
        $this->InventoryFbOrderItemSourceRepositoryInterface = $InventoryFbOrderItemSourceRepositoryInterface;
        $this->InventoryFbOrderItemSourceInterface = $InventoryFbOrderItemSourceInterface;
        //$this->SourcesData = $SourcesData;
        $this->stockIdResolver = $stockIdResolver;
        $this->storeManager = $storeManager;
        $this->logger = $logger;
        $this->scopeConfig = $scopeConfig;
        $this->helperSources = $helperSources;
        $this->eventManager = $eventManager;
        $this->sourceSelectionService = $sourceSelectionService;
        $this->inventoryRequestFactory = $inventoryRequestFactory;
        $this->itemRequestFactory = $itemRequestFactory;
        $this->requestExtensionFactory = $requestExtensionFactory;
        $this->fbOrderitemSourceFactory = $fbOrderitemSourceFactory;
        $this->orderStatusHistoryRepository = $orderStatusHistoryRepository;
        $this->addressInterfaceFactory = $addressInterfaceFactory;
        $this->finalSourceSelectionService = $finalSourceSelectionService;
    }

    /**
     * @param \Magento\Sales\Api\OrderManagementInterface $subject
     * @param $result
     * @param $order
     * @return mixed
     */
    public function afterPlace(
        \Magento\Sales\Api\OrderManagementInterface $subject,
                                                    $result,
                                                    $order
    )
    {
        $executeAfterPlace = $this->executeAfterPlace($order);
        if ($executeAfterPlace === false){
            return $result;
        }
        return $executeAfterPlace;
    }

    public function executeAfterPlace($order){
        $enabled = $this->scopeConfig->getValue('msi/general/enable');

        if (!$enabled) {
            return false;
        }

        try {
            $selection = $this->getSelectionResult($order);
            if ($selection) {
                $this->storeSelection($selection, $order);
            }
        } catch (Throwable $exception) {
            $this->logger->error($exception->getMessage(), ['exception' => $exception]);
        }
        return $order;

    }

    /**
     * @param $order
     * @return SourceSelectionResultInterface|null
     */
    public function getSelectionResult($order)
    {
        $selectedAlgorithmCode = $this->scopeConfig->getValue(self::XML_SOURCE_SELECTION_PATH);

        if (!$selectedAlgorithmCode || !$order) {
            return null;
        }

        try {
            $inventoryRequest = $this->convertOrderToInventoryRequest($order);
            return $this->sourceSelectionService->execute($inventoryRequest, $selectedAlgorithmCode);
        } catch (Throwable $throwable) {
            $this->logger->error($throwable->getMessage(), ['exception' => $throwable]);
            return null;
        }
    }

    /**
     * @param OrderInterface $order
     * @return InventoryRequestInterface
     * @throws LocalizedException
     * @throws NoSuchEntityException
     */
    public function convertOrderToInventoryRequest(OrderInterface $order)
    {
        $websiteId = $this->storeManager->getStore($order->getStoreId())->getWebsiteId();
        $websiteCode = $this->storeManager->getWebsite($websiteId)->getCode();

        $stockId = $this->stockIdResolver->resolve(SalesChannelInterface::TYPE_WEBSITE, $websiteCode);
        $items = [];
        foreach ($order->getItems() as $orderItem) {
            $items[] = $this->itemRequestFactory->create([
                'sku' => $orderItem->getSku(),
                'qty' => $orderItem->getQtyOrdered()
            ]);
        }

        /** @var InventoryRequestInterface $inventoryRequest */
        $inventoryRequest = $this->inventoryRequestFactory->create([
            'stockId' => $stockId,
            'items'   => $items
        ]);

        $extensionAttributes = $inventoryRequest->getExtensionAttributes();

        if ($extensionAttributes === null) {
            $extensionAttributes = $this->requestExtensionFactory->create();
        }

        $extensionAttributes->setOrder($order);
        $extensionAttributes->setUseReservations(true);

        $address = $this->getAddressFromOrder($order);
        if ($address !== null) {
            $extensionAttributes->setDestinationAddress($address);
        }

        return $inventoryRequest;
    }

    /**
     * Create an address from an order
     *
     * @param OrderInterface $order
     *
     * @return null|AddressInterface
     */
    private function getAddressFromOrder(OrderInterface $order): ?AddressInterface
    {
        /** @var Address $shippingAddress */
        $shippingAddress = $order->getShippingAddress();
        if ($shippingAddress === null) {
            return null;
        }

        return $this->addressInterfaceFactory->create(
            [
                'country'  => $shippingAddress->getCountryId(),
                'postcode' => $shippingAddress->getPostcode() ?? '',
                'street'   => implode("\n", $shippingAddress->getStreet()),
                'region'   => $shippingAddress->getRegion() ?? $shippingAddress->getRegionCode() ?? '',
                'city'     => $shippingAddress->getCity() ?? ''
            ]
        );
    }

    /**
     * @param SourceSelectionResultInterface $selection
     * @param $order
     * @throws LocalizedException
     */
    protected function storeSelection(SourceSelectionResultInterface $selection, $order)
    {
        if ($this->scopeConfig->isSetFlag('msi/sources/use_selection_algorithm')) {
            $algorithm = $this->scopeConfig->getValue(
                self::XML_MSI_SOURCES_FINAL_SOURCE_SELECTION_ALGORITHM,
                ScopeInterface::SCOPE_STORE,
                $order->getStoreId()
            );

            /** @var InventoryFbOrderItemSourceInterface[] $orderItems */
            $orderItems = $this->finalSourceSelectionService->execute($algorithm, $order, $selection);

            foreach ($orderItems as $orderItem) {

                if((int)$orderItem->getQty() <= 0) {
                    continue;
                }

                $this->InventoryFbOrderItemSourceRepositoryInterface->save($orderItem);
            }

            return;
        }

        foreach ($selection->getSourceSelectionItems() as $item) {

            // getQtyToDeduct is float 0.0
            if ($item->getQtyToDeduct() == 0) {
                continue;
            }

            $orderItem = $this->findOrderItemFromSku($order, $item->getSku());
            $InventoryFbOrderitemSourceInterface = $this->fbOrderitemSourceFactory->create();
            $InventoryFbOrderitemSourceInterface->setOrderId($order->getEntityId());
            $InventoryFbOrderitemSourceInterface->setOrderItemId($orderItem->getItemId());


            // Using object to manipulate the data over the observer (if needed)
            $obj = new DataObject();
            $obj->setFinalSourceId($item->getSourceCode());
            $obj->setInventorySourceId($item->getSourceCode());
            $this->eventManager->dispatch(
                'ext_inventory_source_selection_before',
                [
                    'order'             => $order,
                    'sources_selection' => $obj,
                    'order_item'        => $orderItem
                ]
            );
            $final_source_id = $obj->getFinalSourceId();
            $source_code = $obj->getInventorySourceId();

            $InventoryFbOrderitemSourceInterface->setInventorySourceId($source_code);
            $InventoryFbOrderitemSourceInterface->setFinalInventorySourceId($final_source_id);
            $InventoryFbOrderitemSourceInterface->setSku($item->getSku());
            $InventoryFbOrderitemSourceInterface->setQty($item->getQtyToDeduct());
            $this->InventoryFbOrderItemSourceRepositoryInterface->save($InventoryFbOrderitemSourceInterface);
        }
    }

    /**
     * @param $order
     * @param $simple_sku
     * @return bool|mixed
     */
    public function findOrderItemFromSku($order, $simple_sku)
    {
        $items = $order->getAllItems();
        foreach ($items as $item) {
            if ($item->getProductType() == 'simple' && $item->getSku() === $simple_sku) {
                return $item;
            }
        }
        return false;
    }
}
