<?php
declare(strict_types=1);

namespace FiloBlu\ExtInventory\Plugin\Api\OrderRepositoryInterface;

use FiloBlu\ExtInventory\Helper\Data;
use Magento\Sales\Api\Data\OrderExtensionFactory;
use Magento\Sales\Api\Data\OrderSearchResultInterface;
use Magento\Sales\Api\OrderRepositoryInterface;

/**
 * Class AfterGet
 * @package FiloBlu\ExtInventory\Plugin\Api\OrderRepositoryInterface
 */
class AfterGetList
{
    /**
     * @var OrderExtensionFactory
     */
    protected $orderExtensionFactory;

    /**
     * @var Data
     */
    private $helperData;

    /**
     * @param OrderExtensionFactory $orderExtensionFactory
     * @param Data $helperData
     */
    public function __construct(
        OrderExtensionFactory $orderExtensionFactory,
        Data                  $helperData
    ) {
        $this->orderExtensionFactory = $orderExtensionFactory;
        $this->helperData = $helperData;
    }

    /**
     * @param OrderRepositoryInterface $subject
     * @param OrderSearchResultInterface $result
     * @return OrderSearchResultInterface
     */
    public function afterGetList(
        OrderRepositoryInterface   $subject,
        OrderSearchResultInterface $result
    ) {

        foreach ($result->getItems() as $item) {
            $extensionAttributes = $item->getExtensionAttributes();

            if (!$extensionAttributes) {
                $extensionAttributes = $this->orderExtensionFactory->create();
                $item->setExtensionAttributes($extensionAttributes);
            }

            $stockType = $this->helperData->getInventoryType($item->getStoreId());
            $extensionAttributes->setFilobluInventoryType($stockType);
            $this->helperData->getFiloBluOrderItems($item);
        }

        return $result;
    }

}
