<?php

namespace FiloBlu\ExtInventory\Plugin\Api\OrderItemRepositoryInterface;

use Exception;
use FiloBlu\ExtInventory\Api\Data\InventoryFbOrderItemSourceInterfaceFactory;
use FiloBlu\ExtInventory\Api\InventoryFbOrderItemSourceRepositoryInterface;
use FiloBlu\ExtInventory\Helper\Data;
use Magento\Framework\Api\SearchCriteriaBuilder;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Sales\Api\Data\OrderItemExtensionInterfaceFactory;
use Magento\Sales\Api\Data\OrderItemInterface;
use Magento\Sales\Api\OrderItemRepositoryInterface;

/**
 * Class AfterGet
 * @package FiloBlu\ExtInventory\Plugin\Api\OrderItemRepositoryInterface
 */
class AfterGet
{

    /**
     * @var InventoryFbOrderItemSourceRepositoryInterface
     */
    private $inventoryFbOrderItemSourceRepository;

    /**
     * @var OrderItemExtensionInterfaceFactory
     */
    private $orderItemExtensionInterfaceFactory;
    /**
     * @var InventoryFbOrderItemSourceInterfaceFactory
     */
    private $fbOrderItemSourceInterfaceFactory;
    /**
     * @var SearchCriteriaBuilder
     */
    private $searchCriteriaBuilder;

    /**
     * OrderItemRepositoryInterface constructor.
     * @param InventoryFbOrderItemSourceRepositoryInterface $inventoryFbOrderItemSourceRepository
     * @param OrderItemExtensionInterfaceFactory $orderItemExtensionInterfaceFactory
     * @param InventoryFbOrderItemSourceInterfaceFactory $fbOrderItemSourceInterfaceFactory
     * @param SearchCriteriaBuilder $searchCriteriaBuilder
     * @param Data $helperData
     */
    public function __construct(
        InventoryFbOrderItemSourceRepositoryInterface $inventoryFbOrderItemSourceRepository,
        OrderItemExtensionInterfaceFactory $orderItemExtensionInterfaceFactory,
        InventoryFbOrderItemSourceInterfaceFactory $fbOrderItemSourceInterfaceFactory,
        SearchCriteriaBuilder $searchCriteriaBuilder
    )
    {
        $this->inventoryFbOrderItemSourceRepository = $inventoryFbOrderItemSourceRepository;
        $this->orderItemExtensionInterfaceFactory = $orderItemExtensionInterfaceFactory;
        $this->fbOrderItemSourceInterfaceFactory = $fbOrderItemSourceInterfaceFactory;
        $this->searchCriteriaBuilder = $searchCriteriaBuilder;
    }

    /**
     * @param OrderItemRepositoryInterface $subject
     * @param OrderItemInterface $result
     * @param int $id
     * @return OrderItemInterface
     */
    public function afterGet(OrderItemRepositoryInterface $subject, $result, $id)
    {
        $extensionAttributes = $result->getExtensionAttributes();

        if ($extensionAttributes === null) {
            $extensionAttributes = $this->orderItemExtensionInterfaceFactory->create();
        }

        try {
            $this->searchCriteriaBuilder->addFilter('order_item_id', $id);
            $filoBluOrderItem = $this->inventoryFbOrderItemSourceRepository->getList($this->searchCriteriaBuilder->addFilter('order_item_id', $id)->create());
            $extensionAttributes->setFilobluOrderItem($filoBluOrderItem->getItems());
        } catch (Exception $exception) {
            $extensionAttributes->setFilobluOrderItem($this->fbOrderItemSourceInterfaceFactory->create());
        }

        $result->setExtensionAttributes($extensionAttributes);

        return $result;
    }
}
