<?php

namespace FiloBlu\ExtInventory\Model;

use Magento\Framework\Serialize\SerializerInterface;
use Magento\Sales\Api\OrderRepositoryInterface;

/**
 * Class ReservationStatus
 * @package FiloBlu\ExtInventory\Model
 */
class ReservationStatus
{

    /**
     * @var int
     */
    const STATUS_CLEANED = 0;
    /**
     * @var int
     */
    const STATUS_ERROR = 1;
    /**
     * @var int
     */
    const STATUS_PENDING = -1;
    /**
     * @var
     */
    protected $status;

    /**
     * @var
     */
    protected $orderId;
    /**
     * @var array
     */
    protected $reservations = [];
    /**
     * @var SerializerInterface
     */
    private $serializer;
    /**
     * @var OrderRepositoryInterface
     */
    private $orderRepository;

    /**
     * ReservationStatus constructor.
     * @param OrderRepositoryInterface $orderRepository
     * @param SerializerInterface $serializer
     */
    public function __construct(
        OrderRepositoryInterface $orderRepository,
        SerializerInterface $serializer
    ) {
        $this->serializer = $serializer;
        $this->orderRepository = $orderRepository;
    }

    /**
     * @return int
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @param mixed $status
     * @return ReservationStatus
     */
    public function setStatus($status)
    {
        $this->status = $status;
        return $this;
    }

    /**
     * @return array
     */
    public function getReservations()
    {
        return $this->reservations;
    }

    /**
     * @param array $reservations
     * @return ReservationStatus
     */
    public function setReservations(array $reservations)
    {
        $this->reservations = $reservations;
        return $this;
    }

    /**
     * @return array
     */
    public function getInconsistencies()
    {
        $reservations = [];
        foreach ($this->reservations as $reservation) {
            $metadata = $this->serializer->unserialize($reservation['metadata']);
            $event = $metadata['event_type'];
            $sku = $reservation['sku'];

            if (!isset($reservations[$sku][$event])) {
                $reservations[$sku][$event] = 0;
            } else {
                $reservations[$sku][$event] += 1;
            }
        }

        $inconsistencies = [];
        foreach ($reservations as $sku => $reservation) {
            foreach ($reservation as $event => $times) {
                if ($times > 0) {
                    $inconsistencies[$sku][$event] = $times;
                }
            }
        }

        return $inconsistencies;
    }

    /**
     * @return int
     */
    public function getOrderId()
    {
        return $this->orderId;
    }

    /**
     * @param int $orderId
     */
    public function setOrderId($orderId)
    {
        $this->orderId = $orderId;
        return $this;
    }

    /**
     * @return \Magento\Sales\Api\Data\OrderInterface
     */
    public function getOrder(){
        return $this->orderRepository->get($this->getOrderId());
    }
}
