<?php

namespace FiloBlu\ExtInventory\Model;

use Exception;
use FiloBlu\ExtInventory\Api\Data\InventoryFbOrderItemSourceInterface;
use FiloBlu\ExtInventory\Api\Data\InventoryFbOrderItemSourceInterfaceFactory;
use FiloBlu\ExtInventory\Model\ResourceModel\InventoryFbOrderItemSource\Collection;
// Deprecated, SourceSlots\SourcesData has been removed
//use FiloBlu\ExtInventory\Model\ShippingAlgorithms\SourceSlots\SourcesData;
use Magento\Framework\Api\DataObjectHelper;
use Magento\Framework\Model\AbstractModel;
use Magento\Framework\Model\Context;
use Magento\Framework\Registry;
use Magento\Inventory\Model\SourceRepository;

/**
 * Class InventoryFbOrderItemSource
 * @package FiloBlu\ExtInventory\Model
 */
class InventoryFbOrderItemSource extends AbstractModel implements InventoryFbOrderItemSourceInterface
{
    /**
     * @var DataObjectHelper
     */
    protected $dataObjectHelper;
    /**
     * @var string
     */
    protected $_eventPrefix = 'inventory_fb_orderitem_source';
    /**
     * @var InventoryFbOrderItemSourceInterfaceFactory
     */
    protected $inventory_fb_orderitem_sourceDataFactory;
    /**
     * @var SourceRepository
     */
    private $sourceRepository;

    //private $sourcesData;

    /**
     * @param Context $context
     * @param Registry $registry
     * @param InventoryFbOrderItemSourceInterfaceFactory $inventory_fb_orderitem_sourceDataFactory
     * @param DataObjectHelper $dataObjectHelper
     * @param SourceRepository $sourceRepository
     * @param ResourceModel\InventoryFbOrderItemSource $resource
     * @param Collection $resourceCollection
     * @param array $data
     */
    public function __construct(
        Context $context,
        Registry $registry,
        InventoryFbOrderItemSourceInterfaceFactory $inventory_fb_orderitem_sourceDataFactory,
        DataObjectHelper $dataObjectHelper,
        SourceRepository $sourceRepository,
        ResourceModel\InventoryFbOrderItemSource $resource,
        Collection $resourceCollection,
        //SourcesData $sourcesData,
        array $data = []
    ) {

        parent::__construct($context, $registry, $resource, $resourceCollection, $data);
        $this->inventory_fb_orderitem_sourceDataFactory = $inventory_fb_orderitem_sourceDataFactory;
        $this->dataObjectHelper = $dataObjectHelper;
        $this->sourceRepository = $sourceRepository;
        //$this->sourcesData = $sourcesData;
    }

    /**
     * Retrieve inventory_fb_orderitem_source model with inventory_fb_orderitem_source data
     * @return InventoryFbOrderItemSourceInterface
     */
    public function getDataModel()
    {
        $inventory_fb_orderitem_sourceData = $this->getData();

        $inventory_fb_orderitem_sourceDataObject = $this->inventory_fb_orderitem_sourceDataFactory->create();
        $this->dataObjectHelper->populateWithArray(
            $inventory_fb_orderitem_sourceDataObject,
            $inventory_fb_orderitem_sourceData,
            InventoryFbOrderItemSourceInterface::class
        );

        return $inventory_fb_orderitem_sourceDataObject;
    }

    /**
     * @inheritDoc
     */
    public function getInventoryFbOrderitemSourceId()
    {
        return $this->getData(InventoryFbOrderItemSourceInterface::INVENTORY_FB_ORDERITEM_SOURCE_ID);
    }

    /**
     * @inheritDoc
     */
    public function setInventoryFbOrderitemSourceId($inventoryFbOrderitemSourceId)
    {
        $this->setData(InventoryFbOrderItemSourceInterface::INVENTORY_FB_ORDERITEM_SOURCE_ID, $inventoryFbOrderitemSourceId);
    }

    /**
     * @inheritDoc
     */
    public function setOrderId($orderId)
    {
        $this->setData(InventoryFbOrderItemSourceInterface::ORDER_ID, $orderId);
    }

    /**
     * @inheritDoc
     */
    public function getOrderItemId()
    {
        return $this->getData(InventoryFbOrderItemSourceInterface::ORDER_ITEM_ID);
    }

    /**
     * @inheritDoc
     */
    public function setOrderItemId($orderItemId)
    {
        $this->setData(InventoryFbOrderItemSourceInterface::ORDER_ITEM_ID, $orderItemId);
    }

    /**
     * @inheritDoc
     */
    public function setInventorySourceId($inventorySourceId)
    {
        $this->setData(InventoryFbOrderItemSourceInterface::INVENTORY_SOURCE_ID, $inventorySourceId);
    }

    /**
     * @inheritDoc
     */
    public function setFinalInventorySourceId($finalInventorySourceId)
    {
        $this->setData(InventoryFbOrderItemSourceInterface::FINAL_INVENTORY_SOURCE_ID, $finalInventorySourceId);
    }

    /**
     * @inheritDoc
     */
    public function getSku()
    {
        return $this->getData(InventoryFbOrderItemSourceInterface::SKU);
    }

    /**
     * @inheritDoc
     */
    public function setSku($sku)
    {
        $this->setData(InventoryFbOrderItemSourceInterface::SKU, $sku);
    }

    /**
     * @inheritDoc
     */
    public function getQty()
    {
        return $this->getData(InventoryFbOrderItemSourceInterface::QTY);
    }

    /**
     * @inheritDoc
     */
    public function setQty($qty)
    {
        $this->setData(InventoryFbOrderItemSourceInterface::QTY, $qty);
    }

    /**
     * @inheritDoc
     */
    public function getFinalInventorySource()
    {
        try {
            return $this->sourceRepository->get($this->getFinalInventorySourceId());
        } catch (Exception $e) {
            return null;
        }
    }

    /**
     * @inheritDoc
     */
    public function getFinalInventorySourceId()
    {
        return $this->getData(InventoryFbOrderItemSourceInterface::FINAL_INVENTORY_SOURCE_ID);
    }

    /**
     * @inheritDoc
     */
    public function getInventorySource()
    {
        try {
            return $this->sourceRepository->get($this->getInventorySourceId());
        } catch (Exception $e) {
            return null;
        }
    }

    /**
     * @inheritDoc
     */
    public function getInventorySourceId()
    {
        return $this->getData(InventoryFbOrderItemSourceInterface::INVENTORY_SOURCE_ID);
    }

    /**
     * @return null
     * Deprecated, SourceSlots algorithm has been removed
     */
    public function getThirdPartyFinalInventoryCode()
    {
        return null;
        //$order_storeview_id = $this->sourcesData->getOrderStoreviewIdByOrderId($this->getOrderId());
        //return $this->sourcesData->getThirdPartyCodeFromSourceCode(
        //    $this->getFinalInventorySourceId(),
        //    $order_storeview_id
        //);
    }

    /**
     * @inheritDoc
     */
    public function getOrderId()
    {
        return $this->getData(InventoryFbOrderItemSourceInterface::ORDER_ID);
    }

    /**
     * @return null
     * Deprecated, SourceSlots algorithm has been removed
     */
    public function getThirdPartyInventoryCode()
    {
        return null;
        //$orderStoreviewId = $this->sourcesData->getOrderStoreviewIdByOrderId($this->getOrderId());
        //return $this->sourcesData->getThirdPartyCodeFromSourceCode(
        //    $this->getInventorySourceId(),
        //    $orderStoreviewId
        //);
    }
}
