<?php

namespace FiloBlu\ExtInventory\Model\Config\Source;

use Magento\Framework\Data\OptionSourceInterface;
use Magento\Sales\Model\Order;

/**
 * Class OrderState
 * @package FiloBlu\ExtInventory\Model\Config\Source
 */
class OrderState implements OptionSourceInterface
{
    /**
     * @var string[]
     */
    protected $states = [
        Order::STATE_NEW,
        Order::STATE_PROCESSING,
        Order::STATE_COMPLETE,
        Order::STATE_CLOSED,
        Order::STATE_CANCELED,
        Order::STATE_HOLDED,
    ];

    /**
     * @return array
     */
    public function toOptionArray()
    {
        $options = [];
        foreach ($this->states as $code) {
            $options[] = ['value' => $code, 'label' => $code];
        }
        return $options;
    }
}
