<?php
declare(strict_types=1);

namespace FiloBlu\ExtInventory\Model\Algorithm;

use FiloBlu\ExtInventory\Api\Data\InventoryFbOrderItemSourceInterface;
use FiloBlu\ExtInventory\Helper\Order;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\InventorySourceSelectionApi\Api\Data\SourceSelectionResultInterface;
use Magento\Sales\Api\Data\OrderInterface;
use Magento\Store\Model\ScopeInterface;
use Magento\Framework\Serialize\SerializerInterface;

/**
 *
 */
class MatrixFinalSource implements FinalSourceSelectionInterface
{
    const XML_PATH_MSI_SOURCES_ALGORITHM_MATRIX_SOURCE = 'msi/sources/algorithm_matrix_source';
    /**
     * @var ScopeConfigInterface
     */
    private $scopeConfig;

    /**
     * @var Order
     */
    private $orderHelper;

    /**
     * @var SerializerInterface
     */
    private $serializer;

    /**
     * @param ScopeConfigInterface $scopeConfig
     * @param Order $orderHelper
     * @param SerializerInterface $serializer
     */
    public function __construct(ScopeConfigInterface $scopeConfig,
                                Order                $orderHelper,
                                SerializerInterface $serializer
    )
    {

        $this->scopeConfig = $scopeConfig;
        $this->orderHelper = $orderHelper;
        $this->serializer  = $serializer;
    }

    /**
     * @param OrderInterface $order
     * @param SourceSelectionResultInterface $selectionResult
     * @return InventoryFbOrderItemSourceInterface[]
     */
    public function execute(OrderInterface $order, SourceSelectionResultInterface $selectionResult): array
    {
        $finalSources = $this->serializer->unserialize(
            $this->scopeConfig->getValue(self::XML_PATH_MSI_SOURCES_ALGORITHM_MATRIX_SOURCE,
            ScopeInterface::SCOPE_STORE,
            $order->getStoreId())
        );

        $output = [];
        foreach ($selectionResult->getSourceSelectionItems() as $sourceSelectionItem) {

            if ((int)$sourceSelectionItem->getQtyToDeduct() === 0) {
                continue;
            }

            $filoBluOrderItem = $this->orderHelper->orderItemToFiloBluOrderItem($order, $sourceSelectionItem);
            $initialSource = $filoBluOrderItem->getInventorySourceId();
            if($initialSource && $finalSources && is_array($finalSources)) {
                foreach($finalSources as $value){
                    if(isset($value['initial_source']) && $value['initial_source'] == $initialSource
                        && isset($value['final_source']) && $value['final_source'] != ''){
                        $filoBluOrderItem->setFinalInventorySourceId($value['final_source']);
                        break;
                    }
                }
            }
            $output[] = $filoBluOrderItem;
        }
        return $output;
    }
}
