<?php
declare(strict_types=1);

namespace FiloBlu\ExtInventory\Model\Algorithm;

use FiloBlu\ExtInventory\Api\Data\InventoryFbOrderItemSourceInterface;
use FiloBlu\ExtInventory\Helper\Order;
use Magento\InventorySourceSelectionApi\Api\Data\SourceSelectionResultInterface;
use Magento\Sales\Api\Data\OrderInterface;

/**
 *
 */
class FinalSourceSameAsInitialSource implements FinalSourceSelectionInterface
{

    /**
     * @var Order
     */
    private $orderHelper;

    /**
     * @param Order $orderHelper
     */
    public function __construct(
        Order $orderHelper
    )
    {
        $this->orderHelper = $orderHelper;
    }

    /**
     * @param OrderInterface $order
     * @param SourceSelectionResultInterface $selectionResult
     * @return InventoryFbOrderItemSourceInterface[]
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function execute(OrderInterface $order, SourceSelectionResultInterface $selectionResult): array
    {
        $output = [];
        foreach ($selectionResult->getSourceSelectionItems() as $sourceSelectionItem) {
            $filoBluOrderItem = $this->orderHelper->orderItemToFiloBluOrderItem($order, $sourceSelectionItem);
            $filoBluOrderItem->setFinalInventorySourceId($sourceSelectionItem->getSourceCode());
            $output[] = $filoBluOrderItem;
        }
        return $output;
    }
}
