<?php

namespace FiloBlu\ExtInventory\Helper;

use Magento\Directory\Model\Region as ModelDirectoryRegion;
use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Framework\App\Helper\Context;
use Magento\Framework\DataObject;
use Magento\Inventory\Model\ResourceModel\Source\Collection as SourceCollection;
use Magento\Sales\Api\OrderAddressRepositoryInterface;

/**
 * Class Sources
 * @package FiloBlu\ExtInventory\Helper
 */
class Sources extends AbstractHelper
{
    /** @var SourceCollection */
    public $sourcesCollection;
    /** @var OrderAddressRepositoryInterface */
    public $orderAddressRepositoryInterface;
    /** @var ModelDirectoryRegion */
    public $modelDirectoryRegion;

    /**
     * Sources constructor.
     * @param Context $context
     * @param SourceCollection $sourcesCollection
     * @param OrderAddressRepositoryInterface $orderAddressRepositoryInterface
     * @param ModelDirectoryRegion $modelDirectoryRegion
     */
    public function __construct(
        Context $context,
        SourceCollection $sourcesCollection,
        OrderAddressRepositoryInterface $orderAddressRepositoryInterface,
        ModelDirectoryRegion $modelDirectoryRegion
    ) {
        $this->sourcesCollection = $sourcesCollection;
        $this->orderAddressRepositoryInterface = $orderAddressRepositoryInterface;
        $this->modelDirectoryRegion = $modelDirectoryRegion;
        parent::__construct($context);
    }

    /**
     * @return bool
     */
    public function isEnabled(): bool
    {
        return true;
    }

    /**
     * @param null $stock_id
     * @param null $source_code
     * @return DataObject
     */
    public function getSource($stock_id = null, $source_code = null)
    {
        $collection = $this->getSourcesListCollection($stock_id, $source_code);
        return $collection->getFirstItem();
    }

    /**
     * @param null $stock_id
     * @param null $source_code
     * @return SourceCollection
     * Return a collection of sources ordered by priority DESC and with $stock_id filter
     */
    public function getSourcesListCollection($stock_id = null, $source_code = null)
    {

        //array('inventory_source_stock_link' => 'inventory_source_stock_link')
        $this->sourcesCollection->getSelect()
            ->joinLeft(
                'inventory_source_stock_link',
                'main_table.source_code=inventory_source_stock_link.source_code',
                ['priority' => 'inventory_source_stock_link.priority',
                    'stock_id' => 'inventory_source_stock_link.stock_id',
                    'link_id' => 'inventory_source_stock_link.link_id'
                ]
            );

        if ($stock_id) {
            $this->sourcesCollection->getSelect()->where("stock_id={$stock_id}");
        }
        if ($source_code) {
            $this->sourcesCollection->getSelect()->where("main_table.source_code='{$source_code}'");
        }

        $this->sourcesCollection->setOrder('priority', 'ASC');

        return $this->sourcesCollection;
    }

    public function getSourcesArrayById($stock_id)
    {
        return $this->getSourcesListCodeArray($stock_id, true);
    }

    public function getSourcesListCodeArray($stock_id, $by_id = false)
    {
        $sourcesCollection = $this->getSourcesListCollection($stock_id);
        $return = [];
        foreach ($sourcesCollection as $source) {
            if ($by_id) {
                $return[$source->getLinkId()] = $source->getSourceCode();
            } else {
                $return[] = $source->getSourceCode();
            }
        }
        return $return;
    }

    /**
     * @param \Magento\Inventory\Model\Source $source
     * @return OrderAddressRepositoryInterface
     */
    public function getSourceAddress($source)
    {
        $source_data = $source->getData();
        $region = $this->modelDirectoryRegion->load($source->getRegionId());
        $address = $this->orderAddressRepositoryInterface->create();
        $address->setCity($source->getCity());
        $address->setCountryId($source->getCountryId());
        $address->setFirstName($source->getContactName());
        $address->setLastName($source->getContactName());
        $address->setStreet($source->getStreet());
        $address->setPhoneNumber($source->getPhone());
        $address->setTelephone($source->getPhone());
        $address->setRegionCode($region->getCode());
        $address->setZipCode($source->getPostcode());
        $address->setPostcode($source->getPostcode());
        return $address;
    }
}
