<?php
declare(strict_types=1);

namespace FiloBlu\ExtInventory\Console\Command;

use FiloBlu\ExtInventory\Model\OutdatedStockItemCleaner;
use FiloBlu\ExtInventory\Model\StockStatusFixer;
use Magento\Framework\App\Area;
use Magento\Framework\App\State;
use Magento\Framework\Exception\LocalizedException;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class FixInventoryStatusCommand
 * @package FiloBlu\ExtInventory\Console\Command
 */
class FixInventoryStatusCommand extends Command
{
    /**
     * @var OutdatedStockItemCleaner
     */
    private $outdatedStockItemCleaner;
    /**
     * @var StockStatusFixer
     */
    private $stockStatusFixer;
    /**
     * @var State
     */
    private $state;

    /**
     * FixInventoryStatusCommand constructor.
     * @param StockStatusFixer $stockStatusFixer
     * @param OutdatedStockItemCleaner $outdatedStockItemCleaner
     * @param State $state
     * @param string|null $name
     */
    public function __construct(
        StockStatusFixer $stockStatusFixer,
        OutdatedStockItemCleaner $outdatedStockItemCleaner,
        State $state,

        string $name = null
    ) {
        parent::__construct($name);
        $this->outdatedStockItemCleaner = $outdatedStockItemCleaner;
        $this->stockStatusFixer = $stockStatusFixer;
        $this->state = $state;
    }

    /**
     * @param InputInterface $input
     * @param OutputInterface $output
     * @return int|void|null
     * @throws LocalizedException
     */
    public function execute(InputInterface $input, OutputInterface $output)
    {
        try {
            $this->state->getAreaCode();
        } catch (LocalizedException $exception) {
            $this->state->setAreaCode(Area::AREA_ADMINHTML);
        }
        $this->outdatedStockItemCleaner->clean();
        $this->stockStatusFixer->fixStockStatus();

        return 0;
    }

    /**
     *
     */
    protected function configure()
    {
        $this->setName('filoblu:stock:fix')
            ->setDescription('Fix inventory stock status');
    }
}
